package com.ptteng.academy.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.course.model.DperiodTypeRelation;
import com.ptteng.academy.course.service.DperiodTypeRelationService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class DperiodTypeRelationServiceImpl extends BaseDaoServiceImpl implements DperiodTypeRelationService {


    private static final Log log = LogFactory.getLog(DperiodTypeRelationServiceImpl.class);


    @Override
    public Long insert(DperiodTypeRelation dperiodTypeRelation) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + dperiodTypeRelation);

        if (dperiodTypeRelation == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        dperiodTypeRelation.setCreateAt(currentTimeMillis);
        dperiodTypeRelation.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(dperiodTypeRelation);
        } catch (DaoException e) {
            log.error(" insert wrong : " + dperiodTypeRelation);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<DperiodTypeRelation> insertList(List<DperiodTypeRelation> dperiodTypeRelationList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (dperiodTypeRelationList == null ? "null" : dperiodTypeRelationList.size()));

        List<DperiodTypeRelation> resultList = null;

        if (CollectionUtils.isEmpty(dperiodTypeRelationList)) {
            return new ArrayList<DperiodTypeRelation>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (DperiodTypeRelation dperiodTypeRelation : dperiodTypeRelationList) {
            dperiodTypeRelation.setCreateAt(currentTimeMillis);
            dperiodTypeRelation.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<DperiodTypeRelation>) dao.batchSave(dperiodTypeRelationList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + dperiodTypeRelationList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(DperiodTypeRelation.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(DperiodTypeRelation dperiodTypeRelation) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (dperiodTypeRelation == null ? "null" : dperiodTypeRelation.getId()));

        boolean result = false;

        if (dperiodTypeRelation == null) {
            return true;
        }

        dperiodTypeRelation.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(dperiodTypeRelation);
        } catch (DaoException e) {
            log.error(" update wrong : " + dperiodTypeRelation);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + dperiodTypeRelation);
        }
        return result;
    }


    @Override
    public boolean updateList(List<DperiodTypeRelation> dperiodTypeRelationList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (dperiodTypeRelationList == null ? "null" : dperiodTypeRelationList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(dperiodTypeRelationList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (DperiodTypeRelation dperiodTypeRelation : dperiodTypeRelationList) {
            dperiodTypeRelation.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(dperiodTypeRelationList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + dperiodTypeRelationList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + dperiodTypeRelationList.size());

        return result;
    }


    @Override
    public DperiodTypeRelation getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        DperiodTypeRelation dperiodTypeRelation = null;

        if (id == null) {
            return dperiodTypeRelation;
        }

        try {
            dperiodTypeRelation = (DperiodTypeRelation) dao.get(DperiodTypeRelation.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return dperiodTypeRelation;
    }


    @Override
    public List<DperiodTypeRelation> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<DperiodTypeRelation> dperiodTypeRelation = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<DperiodTypeRelation>();
        }

        try {
            dperiodTypeRelation = (List<DperiodTypeRelation>) dao.getList(DperiodTypeRelation.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (dperiodTypeRelation == null ? "null" : dperiodTypeRelation.size()));

        return dperiodTypeRelation;
    }

    @Override
    public List<Long> getIdsByPeriodId(Long pid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info(" get ids by pid,start,limit  ================== " + pid + " , " + start + " , " + limit);
        List<Long> idList = null;

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getIdsByPeriodId", new Object[]{pid}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids wrong by pid,start,limit : " + pid + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }

    @Override
    public List<Long> getIdsByTypeId(Long typeId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info(" get ids by typeId,start,limit  ================== " + typeId + " , " + start + " , " + limit);
        List<Long> idList = null;

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getIdsByTypeId", new Object[]{typeId}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids wrong by typeId,start,limit : " + typeId + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public List<Long> getDperiodTypeRelationIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getDperiodTypeRelationIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countDperiodTypeRelationIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getDperiodTypeRelationIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getDperiodTypeRelationIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

}

