package com.ptteng.academy.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.course.model.BookUnit;
import com.ptteng.academy.course.service.BookUnitService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class BookUnitServiceImpl extends BaseDaoServiceImpl implements BookUnitService {


    private static final Log log = LogFactory.getLog(BookUnitServiceImpl.class);


    @Override
    public Long insert(BookUnit bookUnit) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + bookUnit);

        if (bookUnit == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        bookUnit.setCreateAt(currentTimeMillis);
        bookUnit.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(bookUnit);
        } catch (DaoException e) {
            log.error(" insert wrong : " + bookUnit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<BookUnit> insertList(List<BookUnit> bookUnitList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (bookUnitList == null ? "null" : bookUnitList.size()));

        List<BookUnit> resultList = null;

        if (CollectionUtils.isEmpty(bookUnitList)) {
            return new ArrayList<BookUnit>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (BookUnit bookUnit : bookUnitList) {
            bookUnit.setCreateAt(currentTimeMillis);
            bookUnit.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<BookUnit>) dao.batchSave(bookUnitList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + bookUnitList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(BookUnit.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(BookUnit bookUnit) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (bookUnit == null ? "null" : bookUnit.getId()));

        boolean result = false;

        if (bookUnit == null) {
            return true;
        }

        bookUnit.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(bookUnit);
        } catch (DaoException e) {
            log.error(" update wrong : " + bookUnit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + bookUnit);
        }
        return result;
    }


    @Override
    public boolean updateList(List<BookUnit> bookUnitList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (bookUnitList == null ? "null" : bookUnitList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(bookUnitList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (BookUnit bookUnit : bookUnitList) {
            bookUnit.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(bookUnitList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + bookUnitList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + bookUnitList.size());

        return result;
    }


    @Override
    public BookUnit getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        BookUnit bookUnit = null;

        if (id == null) {
            return bookUnit;
        }

        try {
            bookUnit = (BookUnit) dao.get(BookUnit.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return bookUnit;
    }


    @Override
    public List<BookUnit> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<BookUnit> bookUnit = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<BookUnit>();
        }

        try {
            bookUnit = (List<BookUnit>) dao.getList(BookUnit.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (bookUnit == null ? "null" : bookUnit.size()));

        return bookUnit;
    }


    @Override
    public List<Long> getBookUnitIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getBookUnitIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countBookUnitIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getBookUnitIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getBookUnitIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

    @Override
    public List<Long> getUnitIdsByStatusOrderBySort(Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info(" get ids by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getUnitIdsByStatusOrderBySort", new Object[]{status}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }

    @Override
    public Long getIdByNameAndBookId(String name, Long bid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get id by name  : " + name + " book id : " + bid);
        }
        Long id = null;

        // TODO 参数检查!

        try {

            id = (Long) dao.getMapping("getIdByNameAndBookId", new Object[]{name, bid});

        } catch (DaoException e) {
            log.error(" get id wrong by name  : " + name + " book id : " + bid);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return id;
    }

    @Override
    public List<Long> getBookUnitIdsByBid(Long bid) throws ServiceException, ServiceDaoException {
        log.info(" get ids by bid : " + bid);
        List<Long> idList = null;

        try {
            idList = dao.getIdList("getUnitIdsByBidOrderBySort", new Object[]{bid}, 0, Integer.MAX_VALUE, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong bid : " + bid);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }

    @Override
    public List<Long> getBookUnitIdsByBidAndStatus(Long bid, Integer status) throws ServiceException, ServiceDaoException {
        log.info(" get ids by bid : " + bid + " status : " + status);
        List<Long> idList = null;

        try {
            idList = dao.getIdList("getBookUnitIdsByBidAndStatus", new Object[]{bid, status}, 0, Integer.MAX_VALUE, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong bid : " + bid);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }

    @Override
    public Long getIdBySortAndBookId(Integer sort, Long bid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get id by sort  : " + sort + " book id : " + bid);
        }
        Long id = null;

        // TODO 参数检查!

        try {

            id = (Long) dao.getMapping("getIdBySortAndBookId", new Object[]{sort, bid});

        } catch (DaoException e) {
            log.error(" get id wrong by sort  : " + sort + " book id : " + bid);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return id;
    }

}

