package com.ptteng.academy.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.course.model.BookSubject;
import com.ptteng.academy.course.service.BookSubjectService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class BookSubjectServiceImpl extends BaseDaoServiceImpl implements BookSubjectService {


    private static final Log log = LogFactory.getLog(BookSubjectServiceImpl.class);


    @Override
    public Long insert(BookSubject bookSubject) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + bookSubject);

        if (bookSubject == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        bookSubject.setCreateAt(currentTimeMillis);
        bookSubject.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(bookSubject);
        } catch (DaoException e) {
            log.error(" insert wrong : " + bookSubject);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<BookSubject> insertList(List<BookSubject> bookSubjectList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (bookSubjectList == null ? "null" : bookSubjectList.size()));

        List<BookSubject> resultList = null;

        if (CollectionUtils.isEmpty(bookSubjectList)) {
            return new ArrayList<BookSubject>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (BookSubject bookSubject : bookSubjectList) {
            bookSubject.setCreateAt(currentTimeMillis);
            bookSubject.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<BookSubject>) dao.batchSave(bookSubjectList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + bookSubjectList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(BookSubject.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(BookSubject bookSubject) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (bookSubject == null ? "null" : bookSubject.getId()));

        boolean result = false;

        if (bookSubject == null) {
            return true;
        }

        bookSubject.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(bookSubject);
        } catch (DaoException e) {
            log.error(" update wrong : " + bookSubject);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + bookSubject);
        }
        return result;
    }


    @Override
    public boolean updateList(List<BookSubject> bookSubjectList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (bookSubjectList == null ? "null" : bookSubjectList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(bookSubjectList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (BookSubject bookSubject : bookSubjectList) {
            bookSubject.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(bookSubjectList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + bookSubjectList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + bookSubjectList.size());

        return result;
    }


    @Override
    public BookSubject getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        BookSubject bookSubject = null;

        if (id == null) {
            return bookSubject;
        }

        try {
            bookSubject = (BookSubject) dao.get(BookSubject.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return bookSubject;
    }


    @Override
    public List<BookSubject> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<BookSubject> bookSubject = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<BookSubject>();
        }

        try {
            bookSubject = (List<BookSubject>) dao.getList(BookSubject.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (bookSubject == null ? "null" : bookSubject.size()));

        return bookSubject;
    }

    @Override
    public Long getIdByName(String name) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get id by name  : " + name);
        }
        Long id = null;

        // TODO 参数检查!

        try {

            id = (Long) dao.getMapping("getBookSubjectIdByName", new Object[]{name});

        } catch (DaoException e) {
            log.error(" get id wrong by name  : " + name);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return id;
    }


    @Override
    public List<Long> getBookSubjectIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getBookSubjectIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countBookSubjectIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getBookSubjectIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getBookSubjectIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

    @Override
    public List<Long> getSubjectIdsByStatusOrderBySort(Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        log.info(" get ids by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getBookSubjectIdsByStatusOrderBySort", new Object[]{status}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }

}

