/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.academy.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.course.model.ScoreRecord;
import com.ptteng.academy.course.service.ScoreRecordService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScoreRecordServiceImpl
extends BaseDaoServiceImpl
implements ScoreRecordService {
    private static final Log log = LogFactory.getLog(ScoreRecordServiceImpl.class);

    public Long insert(ScoreRecord scoreRecord) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + scoreRecord));
        if (scoreRecord == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        scoreRecord.setCreateAt(Long.valueOf(currentTimeMillis));
        scoreRecord.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)scoreRecord);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + scoreRecord));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<ScoreRecord> insertList(List<ScoreRecord> scoreRecordList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (scoreRecordList == null ? "null" : Integer.valueOf(scoreRecordList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(scoreRecordList)) {
            return new ArrayList<ScoreRecord>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (ScoreRecord scoreRecord : scoreRecordList) {
            scoreRecord.setCreateAt(Long.valueOf(currentTimeMillis));
            scoreRecord.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(scoreRecordList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + scoreRecordList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(ScoreRecord.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(ScoreRecord scoreRecord) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (scoreRecord == null ? "null" : scoreRecord.getId())));
        boolean result = false;
        if (scoreRecord == null) {
            return true;
        }
        scoreRecord.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)scoreRecord);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + scoreRecord));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + scoreRecord));
        }
        return result;
    }

    public boolean updateList(List<ScoreRecord> scoreRecordList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (scoreRecordList == null ? "null" : Integer.valueOf(scoreRecordList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(scoreRecordList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (ScoreRecord scoreRecord : scoreRecordList) {
            scoreRecord.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(scoreRecordList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + scoreRecordList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + scoreRecordList.size()));
        return result;
    }

    public ScoreRecord getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        ScoreRecord scoreRecord = null;
        if (id == null) {
            return scoreRecord;
        }
        try {
            scoreRecord = (ScoreRecord)this.dao.get(ScoreRecord.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return scoreRecord;
    }

    public List<ScoreRecord> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List scoreRecord = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<ScoreRecord>();
        }
        try {
            scoreRecord = this.dao.getList(ScoreRecord.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (scoreRecord == null ? "null" : Integer.valueOf(scoreRecord.size()))));
        return scoreRecord;
    }

    public List<Long> getScoreRecordIdsByUidOrderByCreateAt(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getScoreRecordIdsByUidOrderByCreateAt", new Object[]{uid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countScoreRecordIdsByUidOrderByCreateAt(Long uid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid  : " + uid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getScoreRecordIdsByUidOrderByCreateAt", new Object[]{uid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid)  : " + uid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getScoreRecordIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getScoreRecordIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countScoreRecordIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getScoreRecordIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getScoreRecordIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

