/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.academy.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.course.model.Progress;
import com.ptteng.academy.course.service.ProgressService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProgressServiceImpl
extends BaseDaoServiceImpl
implements ProgressService {
    private static final Log log = LogFactory.getLog(ProgressServiceImpl.class);

    public Long insert(Progress progress) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + progress));
        if (progress == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        progress.setCreateAt(Long.valueOf(currentTimeMillis));
        progress.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)progress);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + progress));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Progress> insertList(List<Progress> progressList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (progressList == null ? "null" : Integer.valueOf(progressList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(progressList)) {
            return new ArrayList<Progress>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Progress progress : progressList) {
            progress.setCreateAt(Long.valueOf(currentTimeMillis));
            progress.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(progressList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + progressList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Progress.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Progress progress) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (progress == null ? "null" : progress.getId())));
        boolean result = false;
        if (progress == null) {
            return true;
        }
        progress.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)progress);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + progress));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + progress));
        }
        return result;
    }

    public boolean updateList(List<Progress> progressList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (progressList == null ? "null" : Integer.valueOf(progressList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(progressList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Progress progress : progressList) {
            progress.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(progressList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + progressList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + progressList.size()));
        return result;
    }

    public Progress getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Progress progress = null;
        if (id == null) {
            return progress;
        }
        try {
            progress = (Progress)this.dao.get(Progress.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return progress;
    }

    public List<Progress> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List progress = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Progress>();
        }
        try {
            progress = this.dao.getList(Progress.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (progress == null ? "null" : Integer.valueOf(progress.size()))));
        return progress;
    }

    public List<Long> getBookProgressIdsByUserID(Long userID) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get book progress ids by user id : " + userID));
        }
        List ids = null;
        try {
            ids = this.dao.getIdList("getProgressIdsByUserIDAndType", new Object[]{userID}, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), false);
        }
        catch (DaoException e) {
            log.error((Object)(" get book progress ids wrong by user id : " + userID));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + ids));
        }
        return ids;
    }

    public List<Long> getProgressIdsByUserIDAndTypeOrderByCreateAt(Long userID, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by userID,type,start,limit  : " + userID + " , " + type + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getProgressIdsByUserIDAndTypeOrderByCreateAt", new Object[]{userID, type}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by userID,type,start,limit)  : " + userID + " , " + type + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getProgressIdsByUserIDAndTypeOrderByUpdateAt(Long userID, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by userID,type,start,limit  : " + userID + " , " + type + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getProgressIdsByUserIDAndTypeOrderByUpdateAt", new Object[]{userID, type}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by userID,type,start,limit)  : " + userID + " , " + type + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Long getProgressIdsByUserIDAndTargetIDAndType(Long userID, Long targetID, Integer type) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by userID,targetID,type,start,limit  : " + userID + " , " + targetID + " , " + type));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getProgressIdsByUserIDAndTargetIDAndType", new Object[]{userID, targetID, type});
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by userID,targetID,type,start,limit)  : " + userID + " , " + targetID + " , " + type));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + id));
        }
        return id;
    }

    public Integer countProgressIdsByUserIDAndTypeOrderByCreateAt(Long userID, Integer type) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by userID,type  : " + userID + " , " + type));
        }
        Integer count = null;
        try {
            count = this.dao.count("getProgressIdsByUserIDAndTypeOrderByCreateAt", new Object[]{userID, type});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by userID,type)  : " + userID + " , " + type));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countProgressIdsByUserIDAndTargetIDAndType(Long userID, Long targetID, Integer type) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by userID,targetID,type  : " + userID + " , " + targetID + " , " + type));
        }
        Integer count = null;
        try {
            count = this.dao.count("getProgressIdsByUserIDAndTargetIDAndType", new Object[]{userID, targetID, type});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by userID,targetID,type)  : " + userID + " , " + targetID + " , " + type));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getProgressIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getProgressIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countProgressIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getProgressIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getProgressIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

