/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.academy.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.course.model.Locks;
import com.ptteng.academy.course.service.LocksService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocksServiceImpl
extends BaseDaoServiceImpl
implements LocksService {
    private static final Log log = LogFactory.getLog(LocksServiceImpl.class);

    public Long insert(Locks locks) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + locks));
        if (locks == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        locks.setCreateAt(Long.valueOf(currentTimeMillis));
        locks.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)locks);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + locks));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Locks> insertList(List<Locks> locksList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (locksList == null ? "null" : Integer.valueOf(locksList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(locksList)) {
            return new ArrayList<Locks>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Locks locks : locksList) {
            locks.setCreateAt(Long.valueOf(currentTimeMillis));
            locks.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(locksList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + locksList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Locks.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Locks locks) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (locks == null ? "null" : locks.getId())));
        boolean result = false;
        if (locks == null) {
            return true;
        }
        locks.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)locks);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + locks));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + locks));
        }
        return result;
    }

    public boolean updateList(List<Locks> locksList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (locksList == null ? "null" : Integer.valueOf(locksList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(locksList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Locks locks : locksList) {
            locks.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(locksList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + locksList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + locksList.size()));
        return result;
    }

    public Locks getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Locks locks = null;
        if (id == null) {
            return locks;
        }
        try {
            locks = (Locks)this.dao.get(Locks.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return locks;
    }

    public List<Locks> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List locks = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Locks>();
        }
        try {
            locks = this.dao.getList(Locks.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (locks == null ? "null" : Integer.valueOf(locks.size()))));
        return locks;
    }

    public List<Long> getLocksIdsByUserIDAndType(Long userID, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by userID,type,start,limit  : " + userID + " , " + type + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getLocksIdsByUserIDAndType", new Object[]{userID, type}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by userID,type,start,limit)  : " + userID + " , " + type + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Long getLocksIdByUserIDAndTypeAndTargetID(Long userID, Integer type, Long targetID) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by userID , type, targetID : " + userID + " , " + type + " , " + targetID));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getLocksIdByUserIDAndTypeAndTargetID", new Object[]{userID, type, targetID});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong byuserID , type, targetID : " + userID + " , " + type + " , " + targetID));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public Integer countLocksIdsByUserIDAndType(Long userID, Integer type) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by userID,type  : " + userID + " , " + type));
        }
        Integer count = null;
        try {
            count = this.dao.count("getLocksIdsByUserIDAndType", new Object[]{userID, type});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by userID,type)  : " + userID + " , " + type));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getLocksIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getLocksIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countLocksIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getLocksIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getLocksIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

