/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.academy.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.MyTimeUtil;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.course.model.OrderStatistics;
import com.ptteng.academy.course.model.UserOrder;
import com.ptteng.academy.course.service.LessonService;
import com.ptteng.academy.course.service.LocksService;
import com.ptteng.academy.course.service.MemberService;
import com.ptteng.academy.course.service.OrderStatisticsService;
import com.ptteng.academy.course.service.PeriodService;
import com.ptteng.academy.course.service.RecommendStatisticsService;
import com.ptteng.academy.course.service.UserMemberRelationService;
import com.ptteng.academy.course.service.UserOrderService;
import com.ptteng.academy.course.service.UserPaperRelationService;
import com.ptteng.academy.course.service.UserRecommendService;
import com.ptteng.academy.course.service.UserService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class UserOrderServiceImpl
extends BaseDaoServiceImpl
implements UserOrderService {
    private static final Log log = LogFactory.getLog((String)"order");
    @Autowired
    UserPaperRelationService userPaperRelationService;
    @Autowired
    PeriodService periodService;
    @Autowired
    UserService userService;
    @Autowired
    LocksService locksService;
    @Autowired
    LessonService lessonService;
    @Autowired
    MemberService memberService;
    @Autowired
    UserRecommendService userRecommendService;
    @Autowired
    UserMemberRelationService userMemberRelationService;
    @Autowired
    RecommendStatisticsService recommendStatisticsService;
    @Autowired
    OrderStatisticsService orderStatisticsService;

    public Long insert(UserOrder userOrder) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + userOrder));
        if (userOrder == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        userOrder.setCreateAt(Long.valueOf(currentTimeMillis));
        userOrder.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)userOrder);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + userOrder));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<UserOrder> insertList(List<UserOrder> userOrderList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (userOrderList == null ? "null" : Integer.valueOf(userOrderList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(userOrderList)) {
            return new ArrayList<UserOrder>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (UserOrder userOrder : userOrderList) {
            userOrder.setCreateAt(Long.valueOf(currentTimeMillis));
            userOrder.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(userOrderList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + userOrderList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(UserOrder.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(UserOrder userOrder) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (userOrder == null ? "null" : userOrder.getId())));
        boolean result = false;
        if (userOrder == null) {
            return true;
        }
        userOrder.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)userOrder);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + userOrder));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + userOrder));
        }
        return result;
    }

    public boolean updateList(List<UserOrder> userOrderList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (userOrderList == null ? "null" : Integer.valueOf(userOrderList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(userOrderList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (UserOrder userOrder : userOrderList) {
            userOrder.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(userOrderList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + userOrderList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + userOrderList.size()));
        return result;
    }

    public UserOrder getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        UserOrder userOrder = null;
        if (id == null) {
            return userOrder;
        }
        try {
            userOrder = (UserOrder)this.dao.get(UserOrder.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return userOrder;
    }

    public List<UserOrder> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List userOrder = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<UserOrder>();
        }
        try {
            userOrder = this.dao.getList(UserOrder.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (userOrder == null ? "null" : Integer.valueOf(userOrder.size()))));
        return userOrder;
    }

    public UserOrder getOrderObjectByOrderId(String orderId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by order_id  : " + orderId));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getIdByOrderId", new Object[]{orderId});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by orderId  : " + orderId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return this.getObjectById(id);
    }

    public List<Long> getUserOrderIdsByUidAndBuyType(Long uid, Integer buyType, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,buyType,start,limit  : " + uid + " , " + buyType + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserOrderIdsByUidAndBuyType", new Object[]{uid, buyType}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,buyType,start,limit)  : " + uid + " , " + buyType + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Long getUserOrderIdsByUidAndBuyTypeAndTargetId(Long uid, Integer buyType, Long targetId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by uid,buyType,targetId : " + uid + " , " + buyType + " , " + targetId));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getUserOrderIdsByUidAndBuyTypeAndTargetId", new Object[]{uid, buyType, targetId});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by uid,buyType,targetId : " + uid + " , " + buyType + " , " + targetId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getUserOrderIdsByUidAndBuyTypeAndStatus(Long uid, Integer buyType, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by uid,buyType,status : " + uid + " , " + buyType + " , " + status));
        }
        List ids = null;
        try {
            ids = this.dao.getIdList("getUserOrderIdsByUidAndBuyTypeAndStatus", new Object[]{uid, buyType, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by uid,buyType,status : " + uid + " , " + buyType + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + ids));
        }
        return ids;
    }

    public List<Long> getUserOrderIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserOrderIdsByUid", new Object[]{uid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getUserOrderIdsByUidAndStatus(Long uid, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid, status,start,limit  : " + uid + " , " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserOrderIdsByUidAndStatus", new Object[]{uid, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,status,start,limit)  : " + uid + " , " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getUserOrderIdsByUidAndStatusAndOs(Long uid, Integer status, Integer os, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid, status, os, start, limit  : " + uid + " , " + status + " , " + os + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserOrderIdsByUidAndStatusAndOs", new Object[]{uid, status, os}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,status,os,start,limit)  : " + uid + " , " + status + " , " + os + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getPaperUserOrderIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getPaperUserOrderIdsByUid", new Object[]{uid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countUserOrderIdsByUidAndBuyType(Long uid, Integer buyType) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid,buyType  : " + uid + " , " + buyType));
        }
        Integer count = null;
        try {
            count = this.dao.count("getUserOrderIdsByUidAndBuyType", new Object[]{uid, buyType});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid,buyType)  : " + uid + " , " + buyType));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countUserOrderIdsByUid(Long uid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid  : " + uid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getUserOrderIdsByUid", new Object[]{uid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid)  : " + uid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getUserOrderIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserOrderIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countUserOrderIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getUserOrderIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getUserOrderIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public void noticeBack(String indentCode, int respCode, int payManner, String os) throws ServiceException, ServiceDaoException {
    }

    public static String getDate(Long time) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = "";
        if (null != time) {
            date = dateFormat.format(new Date(time));
        }
        return date;
    }

    public void addOrderStatistics(Integer buyType, Integer payManner, BigDecimal price) throws ServiceException, ServiceDaoException {
        log.info((Object)" add recommend statistics ");
        Long staticAt = MyTimeUtil.getTodayZeroTimeMillions();
        log.info((Object)(" today is = " + UserOrderServiceImpl.getDate(staticAt)));
        Long sid = this.orderStatisticsService.getOrderStatisticsIdByStaticAt(staticAt);
        OrderStatistics orderStatistics = this.orderStatisticsService.getObjectById(sid);
        if (orderStatistics != null) {
            log.info((Object)" add 1 ");
            orderStatistics.setOrderCount(Integer.valueOf(orderStatistics.getOrderCount() + 1));
            orderStatistics.setTotalAmount(orderStatistics.getTotalAmount().add(price));
            switch (buyType) {
                case 1: {
                    orderStatistics.setLessonCount(Integer.valueOf(orderStatistics.getLessonCount() + 1));
                    orderStatistics.setLessonAmount(orderStatistics.getLessonAmount().add(price));
                    break;
                }
                case 2: {
                    orderStatistics.setLessonCount(Integer.valueOf(orderStatistics.getLessonCount() + 1));
                    orderStatistics.setLessonAmount(orderStatistics.getLessonAmount().add(price));
                    break;
                }
                case 3: {
                    orderStatistics.setPaperCount(Integer.valueOf(orderStatistics.getPaperCount() + 1));
                    orderStatistics.setPaperAmount(orderStatistics.getPaperAmount().add(price));
                    break;
                }
                case 4: {
                    orderStatistics.setPaperCount(Integer.valueOf(orderStatistics.getPaperCount() + 1));
                    orderStatistics.setPaperAmount(orderStatistics.getPaperAmount().add(price));
                    break;
                }
                case 5: {
                    orderStatistics.setPaperCount(Integer.valueOf(orderStatistics.getPaperCount() + 1));
                    orderStatistics.setPaperAmount(orderStatistics.getPaperAmount().add(price));
                    break;
                }
                case 6: {
                    orderStatistics.setVipCount(Integer.valueOf(orderStatistics.getVipCount() + 1));
                    orderStatistics.setVipAmount(orderStatistics.getVipAmount().add(price));
                }
            }
            switch (payManner) {
                case 3: {
                    orderStatistics.setAlipayAmount(orderStatistics.getAlipayAmount().add(price));
                    break;
                }
                case 4: {
                    orderStatistics.setWeixinAmount(orderStatistics.getWeixinAmount().add(price));
                    break;
                }
                case 5: {
                    orderStatistics.setAppleAmount(orderStatistics.getAppleAmount().add(price));
                }
            }
            this.orderStatisticsService.update(orderStatistics);
        } else {
            log.info((Object)" new  recommendStatistics  ");
            orderStatistics = new OrderStatistics();
            orderStatistics.setStaticAt(staticAt);
            orderStatistics.setOrderCount(Integer.valueOf(1));
            orderStatistics.setTotalAmount(price);
            switch (buyType) {
                case 1: {
                    orderStatistics.setLessonCount(Integer.valueOf(1));
                    orderStatistics.setLessonAmount(price);
                    break;
                }
                case 2: {
                    orderStatistics.setLessonCount(Integer.valueOf(1));
                    orderStatistics.setLessonAmount(price);
                    break;
                }
                case 3: {
                    orderStatistics.setPaperCount(Integer.valueOf(1));
                    orderStatistics.setPaperAmount(price);
                    break;
                }
                case 4: {
                    orderStatistics.setPaperCount(Integer.valueOf(1));
                    orderStatistics.setPaperAmount(price);
                    break;
                }
                case 5: {
                    orderStatistics.setPaperCount(Integer.valueOf(1));
                    orderStatistics.setPaperAmount(price);
                    break;
                }
                case 6: {
                    orderStatistics.setVipCount(Integer.valueOf(1));
                    orderStatistics.setVipAmount(price);
                }
            }
            switch (payManner) {
                case 3: {
                    orderStatistics.setAlipayAmount(price);
                    break;
                }
                case 4: {
                    orderStatistics.setWeixinAmount(price);
                    break;
                }
                case 5: {
                    orderStatistics.setAppleAmount(price);
                }
            }
            this.orderStatisticsService.insert(orderStatistics);
        }
    }
}

