/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.academy.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.course.model.Lesson;
import com.ptteng.academy.course.service.LessonService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LessonServiceImpl
extends BaseDaoServiceImpl
implements LessonService {
    private static final Log log = LogFactory.getLog(LessonServiceImpl.class);

    public Long insert(Lesson lesson) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + lesson));
        if (lesson == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        lesson.setCreateAt(Long.valueOf(currentTimeMillis));
        lesson.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)lesson);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + lesson));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Lesson> insertList(List<Lesson> lessonList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (lessonList == null ? "null" : Integer.valueOf(lessonList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(lessonList)) {
            return new ArrayList<Lesson>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Lesson lesson : lessonList) {
            lesson.setCreateAt(Long.valueOf(currentTimeMillis));
            lesson.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(lessonList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + lessonList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Lesson.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Lesson lesson) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (lesson == null ? "null" : lesson.getId())));
        boolean result = false;
        if (lesson == null) {
            return true;
        }
        lesson.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)lesson);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + lesson));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + lesson));
        }
        return result;
    }

    public boolean updateList(List<Lesson> lessonList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (lessonList == null ? "null" : Integer.valueOf(lessonList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(lessonList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Lesson lesson : lessonList) {
            lesson.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(lessonList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + lessonList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + lessonList.size()));
        return result;
    }

    public Lesson getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Lesson lesson = null;
        if (id == null) {
            return lesson;
        }
        try {
            lesson = (Lesson)this.dao.get(Lesson.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return lesson;
    }

    public List<Lesson> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List lesson = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Lesson>();
        }
        try {
            lesson = this.dao.getList(Lesson.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (lesson == null ? "null" : Integer.valueOf(lesson.size()))));
        return lesson;
    }

    public List<Long> getLessonIdsByLevelOrderBySort(Integer level, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by level,start,limit  : " + level + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getLessonIdsByLevelOrderBySort", new Object[]{level}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by level,start,limit)  : " + level + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getLessonIdsByLevelAndSubjectOrderBySort(Integer level, Long sujectID, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by level,start,limit  : " + level + " , " + start + " , " + limit + "and subject id is" + sujectID));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            log.info((Object)(level + "level" + sujectID + "subjectId=============================="));
            idList = this.dao.getIdList("getLessonIdsByLevelAndSubjectOrderBySort", new Object[]{level, sujectID}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by level,start,limit)  : " + level + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getLessonIdsBySubjectOrderBySort(Long sujectID, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by level,start,limit  : " + sujectID + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getLessonIdsBySubjectOrderBySort", new Object[]{sujectID}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by subjectID,start,limit)  : " + sujectID + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getLessonIdsByRecommendOrderBySort(Integer recommend, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by recommend,start,limit  : " + recommend + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getLessonIdsByRecommendOrderBySort", new Object[]{recommend}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by recommend,start,limit)  : " + recommend + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getLessonIdsBySubjectTypeAndSelected(Integer userType, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by userType,start,limit  : " + userType + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getLessonIdsBySubjectTypeAndSelected", new Object[]{userType}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by userType,start,limit)  : " + userType + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countLessonIdsByLevelOrderBySort(Integer level) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by level  : " + level));
        }
        Integer count = null;
        try {
            count = this.dao.count("getLessonIdsByLevelOrderBySort", new Object[]{level});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by level)  : " + level));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countLessonIdsByLevelAndSubjectOrderBySort(Integer level, Integer subjectId) throws ServiceException, ServiceDaoException {
        return null;
    }

    public Integer countLessonIdsByRecommendOrderBySort(Integer recommend) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by recommend  : " + recommend));
        }
        Integer count = null;
        try {
            count = this.dao.count("getLessonIdsByRecommendOrderBySort", new Object[]{recommend});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by recommend)  : " + recommend));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getLessonIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getLessonIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countLessonIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getLessonIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getLessonIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

