/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.academy.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.course.model.Collaborate;
import com.ptteng.academy.course.service.CollaborateService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CollaborateServiceImpl
extends BaseDaoServiceImpl
implements CollaborateService {
    private static final Log log = LogFactory.getLog(CollaborateServiceImpl.class);

    public Long insert(Collaborate collaborate) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + collaborate));
        if (collaborate == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        collaborate.setCreateAt(Long.valueOf(currentTimeMillis));
        collaborate.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)collaborate);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + collaborate));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Collaborate> insertList(List<Collaborate> collaborateList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (collaborateList == null ? "null" : Integer.valueOf(collaborateList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(collaborateList)) {
            return new ArrayList<Collaborate>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Collaborate collaborate : collaborateList) {
            collaborate.setCreateAt(Long.valueOf(currentTimeMillis));
            collaborate.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(collaborateList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + collaborateList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Collaborate.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Collaborate collaborate) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (collaborate == null ? "null" : collaborate.getId())));
        boolean result = false;
        if (collaborate == null) {
            return true;
        }
        collaborate.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)collaborate);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + collaborate));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + collaborate));
        }
        return result;
    }

    public boolean updateList(List<Collaborate> collaborateList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (collaborateList == null ? "null" : Integer.valueOf(collaborateList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(collaborateList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Collaborate collaborate : collaborateList) {
            collaborate.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(collaborateList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + collaborateList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + collaborateList.size()));
        return result;
    }

    public Collaborate getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Collaborate collaborate = null;
        if (id == null) {
            return collaborate;
        }
        try {
            collaborate = (Collaborate)this.dao.get(Collaborate.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return collaborate;
    }

    public List<Collaborate> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List collaborate = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Collaborate>();
        }
        try {
            collaborate = this.dao.getList(Collaborate.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (collaborate == null ? "null" : Integer.valueOf(collaborate.size()))));
        return collaborate;
    }

    public List<Long> getCollaborateIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getCollaborateIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countCollaborateIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getCollaborateIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getCollaborateIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

