/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.academy.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.course.model.RecommendStatistics;
import com.ptteng.academy.course.service.RecommendStatisticsService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RecommendStatisticsServiceImpl
extends BaseDaoServiceImpl
implements RecommendStatisticsService {
    private static final Log log = LogFactory.getLog(RecommendStatisticsServiceImpl.class);

    public Long insert(RecommendStatistics recommendStatistics) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + recommendStatistics));
        if (recommendStatistics == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        recommendStatistics.setCreateAt(Long.valueOf(currentTimeMillis));
        recommendStatistics.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)recommendStatistics);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + recommendStatistics));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<RecommendStatistics> insertList(List<RecommendStatistics> recommendStatisticsList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (recommendStatisticsList == null ? "null" : Integer.valueOf(recommendStatisticsList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(recommendStatisticsList)) {
            return new ArrayList<RecommendStatistics>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (RecommendStatistics recommendStatistics : recommendStatisticsList) {
            recommendStatistics.setCreateAt(Long.valueOf(currentTimeMillis));
            recommendStatistics.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(recommendStatisticsList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + recommendStatisticsList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(RecommendStatistics.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(RecommendStatistics recommendStatistics) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (recommendStatistics == null ? "null" : recommendStatistics.getId())));
        boolean result = false;
        if (recommendStatistics == null) {
            return true;
        }
        recommendStatistics.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)recommendStatistics);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + recommendStatistics));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + recommendStatistics));
        }
        return result;
    }

    public boolean updateList(List<RecommendStatistics> recommendStatisticsList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (recommendStatisticsList == null ? "null" : Integer.valueOf(recommendStatisticsList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(recommendStatisticsList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (RecommendStatistics recommendStatistics : recommendStatisticsList) {
            recommendStatistics.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(recommendStatisticsList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + recommendStatisticsList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + recommendStatisticsList.size()));
        return result;
    }

    public RecommendStatistics getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        RecommendStatistics recommendStatistics = null;
        if (id == null) {
            return recommendStatistics;
        }
        try {
            recommendStatistics = (RecommendStatistics)this.dao.get(RecommendStatistics.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return recommendStatistics;
    }

    public List<RecommendStatistics> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List recommendStatistics = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<RecommendStatistics>();
        }
        try {
            recommendStatistics = this.dao.getList(RecommendStatistics.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (recommendStatistics == null ? "null" : Integer.valueOf(recommendStatistics.size()))));
        return recommendStatistics;
    }

    public List<Long> getRecommendStatisticsIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getRecommendStatisticsIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getIdsByUserId(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by uid,start,limit  ================== " + uid + " , " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getIdsByUserId", new Object[]{uid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countRecommendStatisticsIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getRecommendStatisticsIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getRecommendStatisticsIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

