/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.academy.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.course.model.Introduce;
import com.ptteng.academy.course.service.IntroduceService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IntroduceServiceImpl
extends BaseDaoServiceImpl
implements IntroduceService {
    private static final Log log = LogFactory.getLog(IntroduceServiceImpl.class);

    public Long insert(Introduce introduce) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + introduce));
        if (introduce == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        introduce.setCreateAt(Long.valueOf(currentTimeMillis));
        introduce.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)introduce);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + introduce));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Introduce> insertList(List<Introduce> introduceList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (introduceList == null ? "null" : Integer.valueOf(introduceList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(introduceList)) {
            return new ArrayList<Introduce>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Introduce introduce : introduceList) {
            introduce.setCreateAt(Long.valueOf(currentTimeMillis));
            introduce.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(introduceList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + introduceList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Introduce.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Introduce introduce) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (introduce == null ? "null" : introduce.getId())));
        boolean result = false;
        if (introduce == null) {
            return true;
        }
        introduce.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)introduce);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + introduce));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + introduce));
        }
        return result;
    }

    public boolean updateList(List<Introduce> introduceList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (introduceList == null ? "null" : Integer.valueOf(introduceList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(introduceList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Introduce introduce : introduceList) {
            introduce.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(introduceList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + introduceList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + introduceList.size()));
        return result;
    }

    public Introduce getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Introduce introduce = null;
        if (id == null) {
            return introduce;
        }
        try {
            introduce = (Introduce)this.dao.get(Introduce.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return introduce;
    }

    public List<Introduce> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List introduce = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Introduce>();
        }
        try {
            introduce = this.dao.getList(Introduce.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (introduce == null ? "null" : Integer.valueOf(introduce.size()))));
        return introduce;
    }

    public List<Long> getIdsByLessonId(Long lessonId) throws ServiceException, ServiceDaoException {
        log.info((Object)" get ids by level,start,limit  : ");
        List idList = null;
        try {
            idList = this.dao.getIdList("getIdsByLessonId", new Object[]{lessonId}, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), false);
        }
        catch (DaoException e) {
            log.error((Object)" get ids  wrong by level,start,limit)  : ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getIntroduceIdsByLevel(Integer level, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by level,start,limit  : " + level + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getIntroduceIdsByLevel", new Object[]{level}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by level,start,limit)  : " + level + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countIntroduceIdsByLevel(Integer level) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by level  : " + level));
        }
        Integer count = null;
        try {
            count = this.dao.count("getIntroduceIdsByLevel", new Object[]{level});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by level)  : " + level));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getIntroduceIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getIntroduceIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countIntroduceIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getIntroduceIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getIntroduceIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

