/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.academy.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.course.model.DictationLevel;
import com.ptteng.academy.course.service.DictationLevelService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DictationLevelServiceImpl
extends BaseDaoServiceImpl
implements DictationLevelService {
    private static final Log log = LogFactory.getLog(DictationLevelServiceImpl.class);

    public Long insert(DictationLevel dictationLevel) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + dictationLevel));
        if (dictationLevel == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        dictationLevel.setCreateAt(Long.valueOf(currentTimeMillis));
        dictationLevel.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)dictationLevel);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + dictationLevel));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<DictationLevel> insertList(List<DictationLevel> dictationLevelList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (dictationLevelList == null ? "null" : Integer.valueOf(dictationLevelList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(dictationLevelList)) {
            return new ArrayList<DictationLevel>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (DictationLevel dictationLevel : dictationLevelList) {
            dictationLevel.setCreateAt(Long.valueOf(currentTimeMillis));
            dictationLevel.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(dictationLevelList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + dictationLevelList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(DictationLevel.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(DictationLevel dictationLevel) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (dictationLevel == null ? "null" : dictationLevel.getId())));
        boolean result = false;
        if (dictationLevel == null) {
            return true;
        }
        dictationLevel.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)dictationLevel);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + dictationLevel));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + dictationLevel));
        }
        return result;
    }

    public boolean updateList(List<DictationLevel> dictationLevelList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (dictationLevelList == null ? "null" : Integer.valueOf(dictationLevelList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(dictationLevelList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (DictationLevel dictationLevel : dictationLevelList) {
            dictationLevel.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(dictationLevelList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + dictationLevelList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + dictationLevelList.size()));
        return result;
    }

    public DictationLevel getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        DictationLevel dictationLevel = null;
        if (id == null) {
            return dictationLevel;
        }
        try {
            dictationLevel = (DictationLevel)this.dao.get(DictationLevel.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return dictationLevel;
    }

    public List<DictationLevel> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List dictationLevel = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<DictationLevel>();
        }
        try {
            dictationLevel = this.dao.getList(DictationLevel.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (dictationLevel == null ? "null" : Integer.valueOf(dictationLevel.size()))));
        return dictationLevel;
    }

    public List<Long> getIdsBySid(Long sid) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids by sid : " + sid));
        List idList = null;
        try {
            idList = this.dao.getIdList("getIdsBySid", new Object[]{sid}, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids wrong by by sid : " + sid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getDictationLevelIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getDictationLevelIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countDictationLevelIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getDictationLevelIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getDictationLevelIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

