package com.ptteng.academy.course.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.academy.course.model.BookVersion;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface BookVersionService extends BaseDaoService {

	



   		   
		
		public Long insert(BookVersion bookVersion)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<BookVersion> insertList(List<BookVersion> bookVersionList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(BookVersion bookVersion)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<BookVersion> bookVersionList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public BookVersion getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<BookVersion> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


				
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getBookVersionIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countBookVersionIds() throws ServiceException, ServiceDaoException;

	/**
	 * @Description 根据版本名称查找id
	 * @param name 版本名称
	 * @Author: PeiyuFeng
	 * @Time 2017/4/5 11:30
	 */
	Long getIdByName(String name) throws ServiceException, ServiceDaoException;
}

