package com.ptteng.academy.course.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.course.model.Answer;
import com.ptteng.common.dao.BaseDaoService;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface AnswerService extends BaseDaoService {


    public Long insert(Answer answer) throws ServiceException, ServiceDaoException;


    public List<Answer> insertList(List<Answer> answerList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(Answer answer) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<Answer> answerList) throws ServiceException, ServiceDaoException;


    public Answer getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<Answer> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countAnswerIdsByTaskIdOrderByCreateAt(Long taskId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getAnswerIdsByTaskIdOrderByCreateAt(Long taskId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getAnswerIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countAnswerIds() throws ServiceException, ServiceDaoException;


}

