package com.ptteng.academy.course.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "lesson_introduction")
public class LessonIntroduction implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 2524411498929169602L;


    /**
     * 图片类型
     */
    public static final Integer IMAGE_TYPE = 2;

    /**
     * 文本类型
     */
    public static final Integer TEXT_TYPE = 1;


    private Long id;


    private Long lessonId;


    private Integer mediaType;


    private String textContent;


    private String resourceURL;


    private Long createAt;


    private Long updateAt;


    private Long createBy;


    private Long updateBy;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "lesson_id")
    public Long getLessonId() {
        return lessonId;
    }


    public void setLessonId(Long lessonId) {
        this.lessonId = lessonId;
    }

    @Column(name = "media_type")
    public Integer getMediaType() {
        return mediaType;
    }


    public void setMediaType(Integer mediaType) {
        this.mediaType = mediaType;
    }

    @Column(name = "text_content")
    public String getTextContent() {
        return textContent;
    }


    public void setTextContent(String textContent) {
        this.textContent = textContent;
    }

    @Column(name = "resource_url")
    public String getResourceURL() {
        return resourceURL;
    }


    public void setResourceURL(String resourceURL) {
        this.resourceURL = resourceURL;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

