/**
 * 
 */
package com.ptteng.sca.academy.course.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.course.model.UserOrder;
import com.ptteng.academy.course.service.UserOrderService;

import java.util.List;
import java.util.Map;

public class UserOrderSCAClient implements UserOrderService {

    private UserOrderService userOrderService;

	public UserOrderService getUserOrderService() {
		return userOrderService;
	}
	
	
	public void setUserOrderService(UserOrderService userOrderService) {
		this.userOrderService =userOrderService;
	}
	
	
			   
		@Override
		public Long insert(UserOrder userOrder)throws ServiceException, ServiceDaoException{
		
		return userOrderService.insert(userOrder);
		          
		
		}	
		  
    	   
		@Override
		public List<UserOrder> insertList(List<UserOrder> userOrderList)throws ServiceException, ServiceDaoException{
		
		return userOrderService.insertList(userOrderList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return userOrderService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(UserOrder userOrder)throws ServiceException, ServiceDaoException{
		
		return userOrderService.update(userOrder);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<UserOrder> userOrderList)throws ServiceException, ServiceDaoException{
		
		return userOrderService.updateList(userOrderList);
		          
		
		}	
		  
    	   
		@Override
		public UserOrder getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return userOrderService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<UserOrder> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return userOrderService.getObjectsByIds(ids);
		          
		
		}

	@Override
	public UserOrder getOrderObjectByOrderId(String orderId) throws ServiceException, ServiceDaoException {
		return userOrderService.getOrderObjectByOrderId(orderId);
	}


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long> getUserOrderIdsByUidAndBuyType(Long uid, Integer buyType, Integer start, Integer limit)throws ServiceException, ServiceDaoException{
		
		return userOrderService.getUserOrderIdsByUidAndBuyType(uid,buyType,start,limit);
	
	
	}

	@Override
	public Long getUserOrderIdsByUidAndBuyTypeAndTargetId(Long uid, Integer buyType, Long targetId) throws ServiceException, ServiceDaoException {
		return userOrderService.getUserOrderIdsByUidAndBuyTypeAndTargetId(uid,buyType,targetId);
	}

	@Override
	public List<Long> getUserOrderIdsByUidAndBuyTypeAndStatus(Long uid, Integer buyType, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		return userOrderService.getUserOrderIdsByUidAndBuyTypeAndStatus(uid, buyType, status, start, limit);
	}


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long> getUserOrderIdsByUid(Long uid, Integer start, Integer limit)throws ServiceException, ServiceDaoException{
		
		return userOrderService.getUserOrderIdsByUid(uid,start,limit);
	
	
	}

	@Override
	public List<Long> getUserOrderIdsByUidAndStatus(Long uid, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		return userOrderService.getUserOrderIdsByUidAndStatus(uid, status, start, limit);
	}

	@Override
	public List<Long> getUserOrderIdsByUidAndStatusAndOs(Long uid, Integer status, Integer os, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		return userOrderService.getUserOrderIdsByUidAndStatusAndOs(uid, status, os, start, limit);
	}

	@Override
	public List<Long> getPaperUserOrderIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		return userOrderService.getPaperUserOrderIdsByUid(uid,start,limit);
	}


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer countUserOrderIdsByUidAndBuyType(Long uid, Integer buyType)throws ServiceException, ServiceDaoException{
		
		return userOrderService.countUserOrderIdsByUidAndBuyType(uid,buyType);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer countUserOrderIdsByUid(Long uid)throws ServiceException, ServiceDaoException{
		
		return userOrderService.countUserOrderIdsByUid(uid);
	
	
	}
	
		
	
		@Override
	public List<Long> getUserOrderIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return userOrderService.getUserOrderIds(start, limit);
	}

	@Override
	public Integer countUserOrderIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return userOrderService.countUserOrderIds();
	}

	@Override
	public void noticeBack(String indentCode, int respCode, int payManner, String os) throws ServiceException, ServiceDaoException {
		userOrderService.noticeBack(indentCode, respCode, payManner, os);
	}


	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return userOrderService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return userOrderService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   userOrderService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
                                              Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.userOrderService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}


 
}

