/**
 * 
 */
package com.ptteng.sca.academy.course.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.course.model.Locks;
import com.ptteng.academy.course.service.LocksService;

import java.util.List;
import java.util.Map;

public class LocksSCAClient implements LocksService {

    private LocksService locksService;

	public LocksService getLocksService() {
		return locksService;
	}
	
	
	public void setLocksService(LocksService locksService) {
		this.locksService =locksService;
	}
	
	
			   
		@Override
		public Long insert(Locks locks)throws ServiceException, ServiceDaoException{
		
		return locksService.insert(locks);
		          
		
		}	
		  
    	   
		@Override
		public List<Locks> insertList(List<Locks> locksList)throws ServiceException, ServiceDaoException{
		
		return locksService.insertList(locksList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return locksService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Locks locks)throws ServiceException, ServiceDaoException{
		
		return locksService.update(locks);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Locks> locksList)throws ServiceException, ServiceDaoException{
		
		return locksService.updateList(locksList);
		          
		
		}	
		  
    	   
		@Override
		public Locks getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return locksService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Locks> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return locksService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long> getLocksIdsByUserIDAndType(Long userID, Integer type, Integer start, Integer limit)throws ServiceException, ServiceDaoException{
		
		return locksService.getLocksIdsByUserIDAndType(userID,type,start,limit);
	
	
	}

	@Override
	public Long getLocksIdByUserIDAndTypeAndTargetID(Long userID, Integer type, Long targetID) throws ServiceException, ServiceDaoException {
		return locksService.getLocksIdByUserIDAndTypeAndTargetID(userID,type,targetID);
	}


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer countLocksIdsByUserIDAndType(Long userID, Integer type)throws ServiceException, ServiceDaoException{
		
		return locksService.countLocksIdsByUserIDAndType(userID,type);
	
	
	}
	
		
	
		@Override
	public List<Long> getLocksIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return locksService.getLocksIds(start, limit);
	}

	@Override
	public Integer countLocksIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return locksService.countLocksIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return locksService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return locksService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   locksService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
                                              Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.locksService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}


 
}

