package com.ptteng.academy.course.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.course.model.Task;
import com.ptteng.common.dao.BaseDaoService;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface TaskService extends BaseDaoService {


    public Long insert(Task task) throws ServiceException, ServiceDaoException;


    public List<Task> insertList(List<Task> taskList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(Task task) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<Task> taskList) throws ServiceException, ServiceDaoException;


    public Task getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<Task> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    public List<Long> getTaskIdsByName(String name) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countTaskIdsByPeriodIDOrderBySort(Long periodID) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getTaskIdsByPeriodIDOrderBySort(Long periodID, Integer start, Integer limit) throws ServiceException, ServiceDaoException;

    /**
     * 根据序列获得任务
     *
     * @param periodID
     * @param sort
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getTaskIdsByPeriodIDAndSort(Long periodID, Integer sort) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getTaskIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countTaskIds() throws ServiceException, ServiceDaoException;


}

