package com.ptteng.academy.course.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.academy.course.model.DictationLesson;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface DictationLessonService extends BaseDaoService {

	



   		   
		
		public Long insert(DictationLesson dictationLesson)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<DictationLesson> insertList(List<DictationLesson> dictationLessonList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(DictationLesson dictationLesson)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<DictationLesson> dictationLessonList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public DictationLesson getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<DictationLesson> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	

	/**
	 * @Description 根据科目难度获取听写课程列表
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/5/17 10:35
	 */
	public List<Long> getLessonListBySidAndLid(Long sid, Long lid, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


	/**
	 * @Description 根据科目难度获取听写课程列表
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/5/17 10:35
	 */
	public Integer countLessonListBySidAndLid(Long sid, Long lid) throws ServiceException, ServiceDaoException;


	/**
	 * @Description 根据科目难度状态获取课程列表
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/5/17 15:30
	 */
	public List<Long> getLessonListBySidAndLidAndStatus(Long sid, Long lid, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


	/**
	 * @Description 根据科目难度状态获取课程列表
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/5/17 15:30
	 */
	public Integer countLessonListBySidAndLidAndStatus(Long sid, Long lid, Integer status) throws ServiceException, ServiceDaoException;



	/**
	 * @Description 根据科目id获取课程列表
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/5/18 16:01
	 */
	public List<Long> getLessonListBySid(Long sid, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


	/**
	 * @Description 根据科目id获取上架课程列表
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/5/18 16:28
	 */
	public List<Long> getLessonListBySidAndStatus(Long sid, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException;




	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getDictationLessonIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countDictationLessonIds() throws ServiceException, ServiceDaoException;
	

}

