/**
 *
 */
package com.ptteng.sca.academy.course.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.course.model.Advert;
import com.ptteng.academy.course.service.AdvertService;

import java.util.List;
import java.util.Map;

public class AdvertSCAClient implements AdvertService {

    private AdvertService advertService;

    public AdvertService getAdvertService() {
        return advertService;
    }


    public void setAdvertService(AdvertService advertService) {
        this.advertService = advertService;
    }


    @Override
    public Long insert(Advert advert) throws ServiceException, ServiceDaoException {

        return advertService.insert(advert);


    }


    @Override
    public List<Advert> insertList(List<Advert> advertList) throws ServiceException, ServiceDaoException {

        return advertService.insertList(advertList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return advertService.delete(id);


    }


    @Override
    public boolean update(Advert advert) throws ServiceException, ServiceDaoException {

        return advertService.update(advert);


    }


    @Override
    public boolean updateList(List<Advert> advertList) throws ServiceException, ServiceDaoException {

        return advertService.updateList(advertList);


    }


    @Override
    public Advert getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return advertService.getObjectById(id);


    }


    @Override
    public List<Advert> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return advertService.getObjectsByIds(ids);


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getAdvertIdsByType(Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return advertService.getAdvertIdsByType(type, start, limit);


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countAdvertIdsByType(Integer type) throws ServiceException, ServiceDaoException {

        return advertService.countAdvertIdsByType(type);


    }


    @Override
    public List<Long> getAdvertIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return advertService.getAdvertIds(start, limit);
    }

    @Override
    public Integer countAdvertIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return advertService.countAdvertIds();
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return advertService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return advertService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        advertService.deleteList(clz, ids);

    }

    @Override
    public Object getObjectByDynamicCondition(Class clz,
                                              Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.advertService.getObjectByDynamicCondition(clz, conditions, start, limit);
    }


}

