package com.ptteng.academy.course.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.course.model.UserOrder;
import com.ptteng.common.dao.BaseDaoService;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface UserOrderService extends BaseDaoService {


    public Long insert(UserOrder userOrder) throws ServiceException, ServiceDaoException;


    public List<UserOrder> insertList(List<UserOrder> userOrderList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(UserOrder userOrder) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<UserOrder> userOrderList) throws ServiceException, ServiceDaoException;


    public UserOrder getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<UserOrder> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public UserOrder getOrderObjectByOrderId(String orderId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countUserOrderIdsByUidAndBuyType(Long uid, Integer buyType) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countUserOrderIdsByUid(Long uid) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getUserOrderIdsByUidAndBuyType(Long uid, Integer buyType, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getUserOrderIdsByUidAndBuyTypeAndTargetId(Long uid, Integer buyType, Long targetId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getUserOrderIdsByUidAndBuyTypeAndStatus(Long uid, Integer buyType, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getUserOrderIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getUserOrderIdsByUidAndStatus(Long uid, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getUserOrderIdsByUidAndStatusAndOs(Long uid, Integer status, Integer os, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getPaperUserOrderIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getUserOrderIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countUserOrderIds() throws ServiceException, ServiceDaoException;


    public void noticeBack(String indentCode, int respCode, int payManner, String os) throws ServiceException, ServiceDaoException;


}

