package com.ptteng.academy.course.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.academy.course.model.Progress;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface ProgressService extends BaseDaoService {

	



   		   
		
		public Long insert(Progress progress)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Progress> insertList(List<Progress> progressList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Progress progress)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Progress> progressList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Progress getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Progress> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;





	/**
	 *根据用户获取学习教材id
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getBookProgressIdsByUserID(Long userID)throws ServiceException, ServiceDaoException;

			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countProgressIdsByUserIDAndTypeOrderByCreateAt(Long userID, Integer type)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countProgressIdsByUserIDAndTargetIDAndType(Long userID, Long targetID, Integer type)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getProgressIdsByUserIDAndTypeOrderByCreateAt(Long userID, Integer type, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getProgressIdsByUserIDAndTypeOrderByUpdateAt(Long userID, Integer type, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long getProgressIdsByUserIDAndTargetIDAndType(Long userID, Long targetID, Integer type)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getProgressIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countProgressIds() throws ServiceException, ServiceDaoException;



//	public Integer getProgressIdsByUserIDAndTargetIDAndType() throws ServiceException, ServiceDaoException;
}

