package com.ptteng.academy.course.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.course.model.Lesson;
import com.ptteng.common.dao.BaseDaoService;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface LessonService extends BaseDaoService {


    public Long insert(Lesson lesson) throws ServiceException, ServiceDaoException;


    public List<Lesson> insertList(List<Lesson> lessonList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(Lesson lesson) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<Lesson> lessonList) throws ServiceException, ServiceDaoException;


    public Lesson getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<Lesson> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countLessonIdsByLevelOrderBySort(Integer level) throws ServiceException, ServiceDaoException;

    /**
     * 根据课程年级查询
     *
     * @param level
     * @param subjectId
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countLessonIdsByLevelAndSubjectOrderBySort(Integer level, Integer subjectId) throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countLessonIdsByRecommendOrderBySort(Integer recommend) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getLessonIdsByLevelOrderBySort(Integer level, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * 根据等级和科目搜课程
     *
     * @param level
     * @param sujectID
     * @param start
     * @param limit
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getLessonIdsByLevelAndSubjectOrderBySort(Integer level, Long sujectID, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * 根据科目查课程
     *
     * @param sujectID
     * @param start
     * @param limit
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getLessonIdsBySubjectOrderBySort(Long sujectID, Integer start, Integer limit) throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getLessonIdsByRecommendOrderBySort(Integer recommend, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * 根据等级和科目搜课程
     *
     * @param userType
     * @param start
     * @param limit
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getLessonIdsBySubjectTypeAndSelected(Integer userType, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getLessonIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countLessonIds() throws ServiceException, ServiceDaoException;


}

