package com.ptteng.academy.course.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.course.model.Advert;
import com.ptteng.common.dao.BaseDaoService;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface AdvertService extends BaseDaoService {

	



   		   
		
		public Long insert(Advert advert)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Advert> insertList(List<Advert> advertList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Advert advert)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Advert> advertList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Advert getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Advert> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countAdvertIdsByType(Integer type)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getAdvertIdsByType(Integer type, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getAdvertIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countAdvertIds() throws ServiceException, ServiceDaoException;
	

}

