package com.ptteng.academy.course.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.course.model.AdGradePlatform;
import com.ptteng.common.dao.BaseDaoService;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface AdGradePlatformService extends BaseDaoService {


    public Long insert(AdGradePlatform adGradePlatform) throws ServiceException, ServiceDaoException;


    public List<AdGradePlatform> insertList(List<AdGradePlatform> adGradePlatformList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(AdGradePlatform adGradePlatform) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<AdGradePlatform> adGradePlatformList) throws ServiceException, ServiceDaoException;


    public AdGradePlatform getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<AdGradePlatform> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getAdGradePlatformIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countAdGradePlatformIds() throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getAdGradePlatformIdsByAdvertId(Long advertId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


}

