package com.ptteng.academy.course.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.academy.course.model.QuesbankTask;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface QuesbankTaskService extends BaseDaoService {


    public Long insert(QuesbankTask quesbankTask) throws ServiceException, ServiceDaoException;


    public List<QuesbankTask> insertList(List<QuesbankTask> quesbankTaskList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(QuesbankTask quesbankTask) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<QuesbankTask> quesbankTaskList) throws ServiceException, ServiceDaoException;


    public QuesbankTask getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<QuesbankTask> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countQuesbankTaskIdsByQuesbankIdAndStatus(Long quesbankId, Integer status) throws ServiceException, ServiceDaoException;

    public Long getQuesbankTaskIdByQuesbankIdAndTaskId(Long quesbankId, Long taskId) throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countQuesbankTaskIdsByTaskIdAndStatus(Long taskId, Integer status) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countQuesbankTaskIdsByQuesbankIdAndStatusAndSpecificType(Long quesbankId, Integer status, Integer specificType) throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countQuesbankTaskIdsByQuesbankIdAndStatusAndDoubleSpecificType(Long quesbankId, Integer status, Integer specificType, Integer specificType2) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getQuesbankTaskIdsByQuesbankIdAndStatusAndSpecificType(Long quesbankId, Integer status, Integer specificType, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getQuesbankTaskIdsByQuesbankIdAndStatus(Long quesbankId, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getQuesbankTaskIdsByTaskIdAndStatus(Long taskId, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getQuesbankTaskIdsByQuesbankIdAndStatusAndDoubleSpecificType(Long quesbankId, Integer status, Integer specificType, Integer specificType2, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getQuesbankTaskIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countQuesbankTaskIds() throws ServiceException, ServiceDaoException;


}

