package com.ptteng.academy.course.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.course.model.Process;
import com.ptteng.common.dao.BaseDaoService;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface ProcessService extends BaseDaoService {


    public Long insert(Process process) throws ServiceException, ServiceDaoException;


    public List<Process> insertList(List<Process> processList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(Process process) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<Process> processList) throws ServiceException, ServiceDaoException;


    public Process getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<Process> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getProcessIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException;

    public List<Long> getProcessIdsByCampaignId(Long campaignId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countProcessIds() throws ServiceException, ServiceDaoException;


}

