package com.ptteng.academy.course.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.course.model.CampaignQuesbank;
import com.ptteng.common.dao.BaseDaoService;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface CampaignQuesbankService extends BaseDaoService {


    public Long insert(CampaignQuesbank campaignQuesbank) throws ServiceException, ServiceDaoException;


    public List<CampaignQuesbank> insertList(List<CampaignQuesbank> campaignQuesbankList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(CampaignQuesbank campaignQuesbank) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<CampaignQuesbank> campaignQuesbankList) throws ServiceException, ServiceDaoException;


    public CampaignQuesbank getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<CampaignQuesbank> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countCampaignQuesbankIdsByCampaignId(Long campaignId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getCampaignQuesbankIdsByCampaignId(Long campaignId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getCampaignQuesbankIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countCampaignQuesbankIds() throws ServiceException, ServiceDaoException;


}

