package com.ptteng.academy.course.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "process")
public class Process implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 5551284742593467392L;


    private Long id;

    private Long campaignId;

    private String title;


    private Long startAt;


    private Long endAt;


    private String image;


    private String content;

    private String audioContent;

    private Integer submitType;


    private Long timeLimit;


    private String quesBankIds;


    private String url;

    private Integer attemptLimit;
    private String quesInfo;

    public static Integer TYPE_ANSWER = 1;
    public static Integer TYPE_AUDIO = 2;
    public static Integer TYPE_THIRD_PARTY = 3;
    public static Integer STATUS_UP = 1;
    public static Integer STATUS_DOWN = 2;

    private Integer status;
    private Integer sort;

    private Long createBy;


    private Long updateBy;


    private Long updateAt;


    private Long createAt;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "campaign_id")
    public Long getCampaignId() {
        return campaignId;
    }

    public void setCampaignId(Long campaignId) {
        this.campaignId = campaignId;
    }

    @Column(name = "title")
    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Column(name = "start_at")
    public Long getStartAt() {
        return startAt;
    }


    public void setStartAt(Long startAt) {
        this.startAt = startAt;
    }

    @Column(name = "end_at")
    public Long getEndAt() {
        return endAt;
    }


    public void setEndAt(Long endAt) {
        this.endAt = endAt;
    }

    @Column(name = "image")
    public String getImage() {
        return image;
    }


    public void setImage(String image) {
        this.image = image;
    }

    @Column(name = "content")
    public String getContent() {
        return content;
    }


    public void setContent(String content) {
        this.content = content;
    }

    @Column(name = "submit_type")
    public Integer getSubmitType() {
        return submitType;
    }


    public void setSubmitType(Integer submitType) {
        this.submitType = submitType;
    }

    @Column(name = "time_limit")
    public Long getTimeLimit() {
        return timeLimit;
    }


    public void setTimeLimit(Long timeLimit) {
        this.timeLimit = timeLimit;
    }

    @Column(name = "ques_bank_ids")
    public String getQuesBankIds() {
        return quesBankIds;
    }


    public void setQuesBankIds(String quesBankIds) {
        this.quesBankIds = quesBankIds;
    }

    @Column(name = "url")
    public String getUrl() {
        return url;
    }


    public void setUrl(String url) {
        this.url = url;
    }

    @Column(name = "attempt_limit")
    public Integer getAttemptLimit() {
        return attemptLimit;
    }

    public void setAttemptLimit(Integer attemptLimit) {
        this.attemptLimit = attemptLimit;
    }

    @Column(name = "ques_info")
    public String getQuesInfo() {
        return quesInfo;
    }

    public void setQuesInfo(String quesInfo) {
        this.quesInfo = quesInfo;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "audio_content")
    public String getAudioContent() {
        return audioContent;
    }

    public void setAudioContent(String audioContent) {
        this.audioContent = audioContent;
    }

    @Column(name = "sort")
    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

