package com.ptteng.academy.course.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "period")
public class Period implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 8646555666912145408L;

    public static final Integer status_normal = 1;
    public static final Integer status_freeze = 2;

    private Long id;

    private String periodName;

    private String introText;

    private String frontCoverURL;

    private String appCoverURL;

    private Integer sort;

    private Long lessonId;

    private String lessonName;

    private Long subjectId;

    private String subjectName;

    private String subjectFontColour;

    private Integer grade;

    private Integer gradeDept;

    private Long createBy;


    private Long updateBy;


    private Long updateAt;


    private Long createAt;


    private Long firstTaskId;

    private Integer lessonIsLock;
    //上下架状态
    private Integer status = Period.status_freeze;

    /**
     * 标签
     */
    private String tag;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }


    @Column(name = "sort")
    public Integer getSort() {
        return sort;
    }


    public void setSort(Integer sort) {
        this.sort = sort;
    }

    @Column(name = "lesson_id")
    public Long getLessonId() {
        return lessonId;
    }

    public void setLessonId(Long lessonId) {
        this.lessonId = lessonId;
    }

    @Column(name = "subject_id")
    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }


    @Transient
    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    @Transient
    public String getLessonName() {
        return lessonName;
    }

    public void setLessonName(String lessonName) {
        this.lessonName = lessonName;
    }

    @Column(name = "period_name")
    public String getPeriodName() {
        return periodName;
    }

    public void setPeriodName(String periodName) {
        this.periodName = periodName;
    }

    @Column(name = "intro_text")
    public String getIntroText() {
        return introText;
    }

    public void setIntroText(String introText) {
        this.introText = introText;
    }

    @Column(name = "front_cover_url")
    public String getFrontCoverURL() {
        return frontCoverURL;
    }

    public void setFrontCoverURL(String frontCoverURL) {
        this.frontCoverURL = frontCoverURL;
    }

    @Column(name = "app_cover_url")
    public String getAppCoverURL() {
        return appCoverURL;
    }

    public void setAppCoverURL(String appCoverURL) {
        this.appCoverURL = appCoverURL;
    }

    @Column(name = "grade")
    public Integer getGrade() {
        return grade;
    }

    public void setGrade(Integer grade) {
        this.grade = grade;
    }

    @Column(name = "grade_dept")
    public Integer getGradeDept() {
        return gradeDept;
    }

    public void setGradeDept(Integer gradeDept) {
        this.gradeDept = gradeDept;
    }

    @Column(name = "tag")
    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    @Transient
    public Long getFirstTaskId() {
        return firstTaskId;
    }

    public void setFirstTaskId(Long firstTaskId) {
        this.firstTaskId = firstTaskId;
    }

    @Transient
    public Integer getLessonIsLock() {
        return lessonIsLock;
    }

    public void setLessonIsLock(Integer lessonIsLock) {
        this.lessonIsLock = lessonIsLock;
    }


    @Transient
    public String getSubjectFontColour() {
        return subjectFontColour;
    }

    public void setSubjectFontColour(String subjectFontColour) {
        this.subjectFontColour = subjectFontColour;
    }
}

