/**
 * 
 */
package com.ptteng.sca.academy.course.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.course.model.Progress;
import com.ptteng.academy.course.service.ProgressService;

import java.util.List;
import java.util.Map;

public class ProgressSCAClient implements ProgressService {

    private ProgressService progressService;

	public ProgressService getProgressService() {
		return progressService;
	}
	
	
	public void setProgressService(ProgressService progressService) {
		this.progressService =progressService;
	}
	
	
			   
		@Override
		public Long insert(Progress progress)throws ServiceException, ServiceDaoException{
		
		return progressService.insert(progress);
		          
		
		}	
		  
    	   
		@Override
		public List<Progress> insertList(List<Progress> progressList)throws ServiceException, ServiceDaoException{
		
		return progressService.insertList(progressList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return progressService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Progress progress)throws ServiceException, ServiceDaoException{
		
		return progressService.update(progress);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Progress> progressList)throws ServiceException, ServiceDaoException{
		
		return progressService.updateList(progressList);
		          
		
		}	
		  
    	   
		@Override
		public Progress getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return progressService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Progress> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return progressService.getObjectsByIds(ids);
		          
		
		}

	@Override
	public List<Long> getBookProgressIdsByUserID(Long userID) throws ServiceException, ServiceDaoException {
		return progressService.getBookProgressIdsByUserID(userID);
	}


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long> getProgressIdsByUserIDAndTypeOrderByCreateAt(Long userID, Integer type, Integer start, Integer limit)throws ServiceException, ServiceDaoException{
		
		return progressService.getProgressIdsByUserIDAndTypeOrderByCreateAt(userID,type,start,limit);
	
	
	}

	@Override
	public List<Long> getProgressIdsByUserIDAndTypeOrderByUpdateAt(Long userID, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		return progressService.getProgressIdsByUserIDAndTypeOrderByUpdateAt(userID,type,start,limit);
	}


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long getProgressIdsByUserIDAndTargetIDAndType(Long userID, Long targetID, Integer type)throws ServiceException, ServiceDaoException{
		
		return progressService.getProgressIdsByUserIDAndTargetIDAndType(userID,targetID,type);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer countProgressIdsByUserIDAndTypeOrderByCreateAt(Long userID, Integer type)throws ServiceException, ServiceDaoException{
		
		return progressService.countProgressIdsByUserIDAndTypeOrderByCreateAt(userID,type);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer countProgressIdsByUserIDAndTargetIDAndType(Long userID, Long targetID, Integer type)throws ServiceException, ServiceDaoException{
		
		return progressService.countProgressIdsByUserIDAndTargetIDAndType(userID,targetID,type);
	
	
	}
	
		
	
		@Override
	public List<Long> getProgressIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return progressService.getProgressIds(start, limit);
	}

	@Override
	public Integer countProgressIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return progressService.countProgressIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return progressService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return progressService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   progressService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
                                              Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.progressService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}


 
}

