package com.ptteng.academy.course.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.academy.course.model.BookUnit;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface BookUnitService extends BaseDaoService {

	



   		   
		
		public Long insert(BookUnit bookUnit)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<BookUnit> insertList(List<BookUnit> bookUnitList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(BookUnit bookUnit)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<BookUnit> bookUnitList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public BookUnit getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<BookUnit> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


				
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getBookUnitIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countBookUnitIds() throws ServiceException, ServiceDaoException;


	/**
	 * @Description 获取在线教材单元并按sort排序
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/4/4 22:04
	 */
	List<Long> getUnitIdsByStatusOrderBySort(Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException;

	/**
	 * @Description 根据单元名称与教材id获取单元id
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/4/5 11:16
	 */
	Long getIdByNameAndBookId(String name, Long bid) throws ServiceException, ServiceDaoException;

	/**
	 * @Description 根据教材id获取单元id并按sort排序
	 * @param bid 教材id
	 * @Author: PeiyuFeng
	 * @Time 2017/4/5 21:17
	 */
	List<Long> getBookUnitIdsByBid(Long bid) throws ServiceException, ServiceDaoException;


	/**
	 * @Description 根据教材id获取上线单元id并按sort排序
	 * @param bid 教材id
	 * @Author: PeiyuFeng
	 * @Time 2017/4/5 21:17
	 */
	List<Long> getBookUnitIdsByBidAndStatus(Long bid, Integer status) throws ServiceException, ServiceDaoException;


	/**
	 * @Description 根据教材id与sort顺序取单元id
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/4/26 14:43
	 */
	Long getIdBySortAndBookId(Integer sort, Long bid) throws ServiceException, ServiceDaoException;

}

