/**
 * 
 */
package com.ptteng.sca.academy.course.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.course.model.Period;
import com.ptteng.academy.course.service.PeriodService;

import java.util.List;
import java.util.Map;

public class PeriodSCAClient implements PeriodService {

    private PeriodService periodService;

	public PeriodService getPeriodService() {
		return periodService;
	}
	
	
	public void setPeriodService(PeriodService periodService) {
		this.periodService =periodService;
	}
	
	
			   
		@Override
		public Long insert(Period period)throws ServiceException, ServiceDaoException{
		
		return periodService.insert(period);
		          
		
		}	
		  
    	   
		@Override
		public List<Period> insertList(List<Period> periodList)throws ServiceException, ServiceDaoException{
		
		return periodService.insertList(periodList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return periodService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Period period)throws ServiceException, ServiceDaoException{
		
		return periodService.update(period);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Period> periodList)throws ServiceException, ServiceDaoException{
		
		return periodService.updateList(periodList);
		          
		
		}	
		  
    	   
		@Override
		public Period getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return periodService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Period> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return periodService.getObjectsByIds(ids);
		          
		
		}

	@Override
	public List<Long> getPeriodIdsByName(String name) throws ServiceException, ServiceDaoException {
		return periodService.getPeriodIdsByName(name);
	}


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long> getPeriodIdsByLessonIDOrderBySort(Long lessonID, Integer start, Integer limit)throws ServiceException, ServiceDaoException{
		
		return periodService.getPeriodIdsByLessonIDOrderBySort(lessonID,start,limit);
	
	
	}

	@Override
	public List<Long> getPeriodIdsByLessonIDAndStatusOrderBySort(Long lessonID, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		return periodService.getPeriodIdsByLessonIDAndStatusOrderBySort(lessonID,status,start,limit);
	}

	@Override
	public List<Long> getPeriodIdsByBookIDAndStatusOrderBySort(Long bookID, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		return periodService.getPeriodIdsByBookIDAndStatusOrderBySort(bookID,status,start,limit);
	}

	@Override
	public List<Long> getPeriodIdsByBookUnitIDAndStatusOrderBySort(Long bookUnitId, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		return periodService.getPeriodIdsByBookUnitIDAndStatusOrderBySort(bookUnitId, status, start	, limit);
	}


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer countPeriodIdsByLessonIDOrderBySort(Long lessonID)throws ServiceException, ServiceDaoException{
		
		return periodService.countPeriodIdsByLessonIDOrderBySort(lessonID);
	
	
	}

	@Override
	public Long getPeriodIdByLessonIDAndSort(Long lessonID, Integer sort) throws ServiceException, ServiceDaoException {
		return periodService.getPeriodIdByLessonIDAndSort(lessonID,sort);
	}

	@Override
	public Long getPeriodIdByUnitIdAndSort(Long unitId, Integer sort) throws ServiceException, ServiceDaoException {
		return periodService.getPeriodIdByUnitIdAndSort(unitId, sort);
	}

	@Override
	public List<Long> getPeriodIdsByBookIdOrderBySort(Long bookID, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		return periodService.getPeriodIdsByBookIdOrderBySort(bookID,start,limit);
	}


	@Override
	public List<Long> getPeriodIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return periodService.getPeriodIds(start, limit);
	}

	@Override
	public Integer countPeriodIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return periodService.countPeriodIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return periodService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return periodService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   periodService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
                                              Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.periodService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}


 
}

