package com.ptteng.academy.course.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.academy.course.model.Period;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface PeriodService extends BaseDaoService {

	



   		   
		
		public Long insert(Period period)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Period> insertList(List<Period> periodList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Period period)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Period> periodList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Period getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Period> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;


	public List<Long> getPeriodIdsByName(String name)throws ServiceException, ServiceDaoException;



			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countPeriodIdsByLessonIDOrderBySort(Long lessonID)throws ServiceException, ServiceDaoException;



	/**
	 * 根据排序查课时
	 * @param lessonID
	 * @param sort
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
     */
	public Long getPeriodIdByLessonIDAndSort(Long lessonID, Integer sort)throws ServiceException, ServiceDaoException;



	/**
	 * 根据排序查课时
	 * @param unitId
	 * @param sort
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long getPeriodIdByUnitIdAndSort(Long unitId, Integer sort)throws ServiceException, ServiceDaoException;



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getPeriodIdsByBookIdOrderBySort(Long bookID, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getPeriodIdsByLessonIDOrderBySort(Long lessonID, Integer start, Integer limit)throws ServiceException, ServiceDaoException;



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getPeriodIdsByLessonIDAndStatusOrderBySort(Long lessonID, Integer status, Integer start, Integer limit)throws ServiceException, ServiceDaoException;



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getPeriodIdsByBookIDAndStatusOrderBySort(Long bookID, Integer status, Integer start, Integer limit)throws ServiceException, ServiceDaoException;




	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getPeriodIdsByBookUnitIDAndStatusOrderBySort(Long bookUnitId, Integer status, Integer start, Integer limit)throws ServiceException, ServiceDaoException;




	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getPeriodIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countPeriodIds() throws ServiceException, ServiceDaoException;
	

}

