package com.ptteng.academy.course.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "subject")
public class Subject implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 728579523720422400L;

    public static final Integer status_normal = 1;
    public static final Integer status_freeze = 2;

    public static final Integer dept_junior_high = 1;
    public static final Integer dept_senior_high = 2;
    public static final Integer dept_study_abroad = 3;

    private Long id;

    /*科目名称*/
    private String subjectName;

    private Integer grade;

    private Integer gradeDept;

    private Integer sort;

    /* 主讲人 */
    private String presenter;

    /*科目介绍*/
    private String introText;

    /*专题字体颜色*/
    private String fontColour;

    /*封面URL*/
    private String frontCoverURL;

    private Integer status = Subject.status_freeze;

    private Long createBy;

    private Long updateBy;

    private Long updateAt;

    private Long createAt;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }


    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }


    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }


    @Column(name = "subject_name")
    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    @Column(name = "grade")
    public Integer getGrade() {
        return grade;
    }

    public void setGrade(Integer grade) {
        this.grade = grade;
    }

    @Column(name = "grade_dept")
    public Integer getGradeDept() {
        return gradeDept;
    }

    public void setGradeDept(Integer gradeDept) {
        this.gradeDept = gradeDept;
    }

    @Column(name = "sort")
    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    @Column(name = "presenter")
    public String getPresenter() {
        return presenter;
    }

    public void setPresenter(String presenter) {
        this.presenter = presenter;
    }

    @Column(name = "intro_text")
    public String getIntroText() {
        return introText;
    }

    public void setIntroText(String introText) {
        this.introText = introText;
    }

    @Column(name = "font_colour")
    public String getFontColour() {
        return fontColour;
    }

    public void setFontColour(String fontColour) {
        this.fontColour = fontColour;
    }

    @Column(name = "front_cover_url")
    public String getFrontCoverURL() {
        return frontCoverURL;
    }

    public void setFrontCoverURL(String frontCoverURL) {
        this.frontCoverURL = frontCoverURL;
    }
}

