/**
 *
 */
package com.ptteng.sca.academy.campaign.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.campaign.model.QuesbankTask;
import com.ptteng.academy.campaign.service.QuesbankTaskService;

import java.util.List;
import java.util.Map;

public class QuesbankTaskSCAClient implements QuesbankTaskService {

    private QuesbankTaskService quesbankTaskService;

    public QuesbankTaskService getQuesbankTaskService() {
        return quesbankTaskService;
    }


    public void setQuesbankTaskService(QuesbankTaskService quesbankTaskService) {
        this.quesbankTaskService = quesbankTaskService;
    }


    @Override
    public Long insert(QuesbankTask quesbankTask) throws ServiceException, ServiceDaoException {

        return quesbankTaskService.insert(quesbankTask);


    }


    @Override
    public List<QuesbankTask> insertList(List<QuesbankTask> quesbankTaskList) throws ServiceException, ServiceDaoException {

        return quesbankTaskService.insertList(quesbankTaskList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return quesbankTaskService.delete(id);


    }


    @Override
    public boolean update(QuesbankTask quesbankTask) throws ServiceException, ServiceDaoException {

        return quesbankTaskService.update(quesbankTask);


    }


    @Override
    public boolean updateList(List<QuesbankTask> quesbankTaskList) throws ServiceException, ServiceDaoException {

        return quesbankTaskService.updateList(quesbankTaskList);


    }


    @Override
    public QuesbankTask getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return quesbankTaskService.getObjectById(id);


    }


    @Override
    public List<QuesbankTask> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return quesbankTaskService.getObjectsByIds(ids);


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getQuesbankTaskIdsByQuesbankIdAndStatusAndSpecificType(Long quesbankId, Integer status, Integer specificType, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return quesbankTaskService.getQuesbankTaskIdsByQuesbankIdAndStatusAndSpecificType(quesbankId, status, specificType, start, limit);


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getQuesbankTaskIdsByQuesbankIdAndStatus(Long quesbankId, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return quesbankTaskService.getQuesbankTaskIdsByQuesbankIdAndStatus(quesbankId, status, start, limit);


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getQuesbankTaskIdsByTaskIdAndStatus(Long taskId, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return quesbankTaskService.getQuesbankTaskIdsByTaskIdAndStatus(taskId, status, start, limit);


    }

    @Override
    public List<Long> getQuesbankTaskIdsByQuesbankIdAndStatusAndDoubleSpecificType(Long quesbankId, Integer status, Integer specificType, Integer specificType2, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        return null;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countQuesbankTaskIdsByQuesbankIdAndStatus(Long quesbankId, Integer status) throws ServiceException, ServiceDaoException {

        return quesbankTaskService.countQuesbankTaskIdsByQuesbankIdAndStatus(quesbankId, status);


    }

    @Override
    public Long getQuesbankTaskIdByQuesbankIdAndTaskId(Long quesbankId, Long taskId) throws ServiceException, ServiceDaoException {
        return quesbankTaskService.getQuesbankTaskIdByQuesbankIdAndTaskId(quesbankId, taskId);
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countQuesbankTaskIdsByTaskIdAndStatus(Long taskId, Integer status) throws ServiceException, ServiceDaoException {

        return quesbankTaskService.countQuesbankTaskIdsByTaskIdAndStatus(taskId, status);


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countQuesbankTaskIdsByQuesbankIdAndStatusAndSpecificType(Long quesbankId, Integer status, Integer specificType) throws ServiceException, ServiceDaoException {

        return quesbankTaskService.countQuesbankTaskIdsByQuesbankIdAndStatusAndSpecificType(quesbankId, status, specificType);


    }

    @Override
    public Integer countQuesbankTaskIdsByQuesbankIdAndStatusAndDoubleSpecificType(Long quesbankId, Integer status, Integer specificType, Integer specificType2) throws ServiceException, ServiceDaoException {
        return quesbankTaskService.countQuesbankTaskIdsByQuesbankIdAndStatusAndDoubleSpecificType(quesbankId, status, specificType, specificType2);
    }


    @Override
    public List<Long> getQuesbankTaskIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return quesbankTaskService.getQuesbankTaskIds(start, limit);
    }

    @Override
    public Integer countQuesbankTaskIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return quesbankTaskService.countQuesbankTaskIds();
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return quesbankTaskService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return quesbankTaskService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        quesbankTaskService.deleteList(clz, ids);

    }

    @Override
    public Object getObjectByDynamicCondition(Class clz,
                                              Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.quesbankTaskService.getObjectByDynamicCondition(clz, conditions, start, limit);
    }


}

