package com.ptteng.academy.campaign.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.campaign.model.UserProcess;
import com.ptteng.common.dao.BaseDaoService;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface UserProcessService extends BaseDaoService {


    public Long insert(UserProcess userProcess) throws ServiceException, ServiceDaoException;


    public List<UserProcess> insertList(List<UserProcess> userProcessList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(UserProcess userProcess) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<UserProcess> userProcessList) throws ServiceException, ServiceDaoException;


    public UserProcess getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<UserProcess> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getUserProcessIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countUserProcessIds() throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getUserProcessIdsByProcessIdAndUserId(Long processId, Long userId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


}

