package com.ptteng.academy.campaign.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.campaign.model.UserProcessRank;
import com.ptteng.common.dao.BaseDaoService;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface UserProcessRankService extends BaseDaoService {


    public Long insert(UserProcessRank userProcessRank) throws ServiceException, ServiceDaoException;


    public List<UserProcessRank> insertList(List<UserProcessRank> userProcessRankList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(UserProcessRank userProcessRank) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<UserProcessRank> userProcessRankList) throws ServiceException, ServiceDaoException;


    public UserProcessRank getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<UserProcessRank> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getUserProcessRankIdByUserIdAndProcessId(Long userId, Long processId) throws ServiceException, ServiceDaoException;

  /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getUserProcessRankIdsByProcessIdAndGradeDept(Long processId, Integer gradeDept, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countUserProcessRankIdsByProcessIdAndGradeDept(Long processId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getUserProcessRankIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countUserProcessRankIds() throws ServiceException, ServiceDaoException;


}

