package com.ptteng.academy.campaign.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.campaign.model.News;
import com.ptteng.common.dao.BaseDaoService;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface NewsService extends BaseDaoService {


    public Long insert(News news) throws ServiceException, ServiceDaoException;


    public List<News> insertList(List<News> newsList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(News news) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<News> newsList) throws ServiceException, ServiceDaoException;


    public News getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<News> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getNewsIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countNewsIds() throws ServiceException, ServiceDaoException;


}

