package com.ptteng.academy.campaign.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "user_news")
public class UserNews implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 2188029574232890368L;


    /**
     * 已读
     */
    public static final Integer READ = 2;

    /**
     * 未读
     */
    public static final Integer NOT_READ = 1;

    public static final Integer TARGET_TYPE_NEWS = 1;

    public static final Integer TARGET_TYPE_DOCUMENT = 2;

    private Long id;

    private Long userId;


    private Long newsId;

    private Integer targetType;

    private Integer isRead;


    private Long createAt;


    private Long updateAt;


    private Long createBy;


    private Long updateBy;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "user_id")
    public Long getUserId() {
        return userId;
    }


    public void setUserId(Long userId) {
        this.userId = userId;
    }

    @Column(name = "news_id")
    public Long getNewsId() {
        return newsId;
    }


    public void setNewsId(Long newsId) {
        this.newsId = newsId;
    }

    @Column(name = "is_read")
    public Integer getIsRead() {
        return isRead;
    }


    public void setIsRead(Integer isRead) {
        this.isRead = isRead;
    }


    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "target_type")
    public Integer getTargetType() {
        return targetType;
    }

    public void setTargetType(Integer targetType) {
        this.targetType = targetType;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

