package com.ptteng.academy.campaign.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "quesbank_task")
public class QuesbankTask implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 4490399748791734272L;


    /**
     * 未关联题库
     */
    public static final int STATUS_NOT_CONNECT = 2;

    /**
     * 关联题库
     */
    public static final int STATUS_CONNECT = 1;

    /**
     * 多选题
     */
    public static final int exercise_multi_select = 5;

    /**
     * 单选题
     */
    public static final int exercise_single_select = 1;

    /**
     * 判断题
     */
    public static final int exercise_type_TF = 4;


    private Long id;


    private Long quesbankId;


    private Long taskId;


    private Integer specificType;


    private Integer status;


    private Long createBy;


    private Long updateBy;


    private Long updateAt;


    private Long createAt;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "quesbank_id")
    public Long getQuesbankId() {
        return quesbankId;
    }


    public void setQuesbankId(Long quesbankId) {
        this.quesbankId = quesbankId;
    }

    @Column(name = "task_id")
    public Long getTaskId() {
        return taskId;
    }


    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    @Column(name = "specific_type")
    public Integer getSpecificType() {
        return specificType;
    }


    public void setSpecificType(Integer specificType) {
        this.specificType = specificType;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

