package com.ptteng.academy.business.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

import com.ptteng.common.dao.BaseDaoService;
import org.osoa.sca.annotations.Remotable;
import com.ptteng.academy.business.model.Clerk;

import java.util.List;

@Remotable
public interface ClerkService extends BaseDaoService {

	



   		   
		
		public Long insert(Clerk clerk)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Clerk> insertList(List<Clerk> clerkList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Clerk clerk)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Clerk> clerkList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Clerk getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Clerk> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countClerkIdsByAgentId(Long agentId)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countClerkIdsByRegionalManagerId(Long regionalManagerId)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getClerkIdsByAgentId(Long agentId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getClerkIdsByRegionalManagerId(Long regionalManagerId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getClerkIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countClerkIds() throws ServiceException, ServiceDaoException;
	

}

