package com.ptteng.academy.business.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.business.model.Clazz;
import com.ptteng.common.dao.BaseDaoService;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface ClazzService extends BaseDaoService {


    public Long insert(Clazz clazz) throws ServiceException, ServiceDaoException;

    public Long getClazzIdsBySchoolIdAndGradeAndClassNo(Long schoolId, Integer grade, Integer classNo) throws ServiceException, ServiceDaoException;


    public List<Clazz> insertList(List<Clazz> clazzList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(Clazz clazz) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<Clazz> clazzList) throws ServiceException, ServiceDaoException;


    public Clazz getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<Clazz> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countClazzIdsBySchoolId(Long schoolId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getClazzIdsBySchoolId(Long schoolId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getClazzIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countClazzIds() throws ServiceException, ServiceDaoException;


}

