package com.ptteng.academy.admin.util;

import com.gemantic.common.util.StringUtil;
import com.gemantic.dal.config.helper.GroupHelper;
import com.ptteng.academy.user.model.RecommendStatistics;
import com.ptteng.common.dao.util.SQLUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.simple.ParameterizedBeanPropertyRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

import javax.sql.DataSource;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

import static com.ptteng.common.dao.util.SQLUtil.convertTable;

/**
 * Created by liangxj on 2016/12/19.
 */
public class StatisticsUtil {
    private static final Log log = LogFactory.getLog("statUtil");

    public static final String Period_Day = "day";

    public static final String Period_Week = "week";

    public static final String Period_Month = "month";

    public static List<RecommendStatistics> getStatisticsListByMore(String invitationCode, String name, String registerNumStart, String registerNumEnd,
                                                                    String minAmount, String maxAmount, String mobile, Integer start,
                                                                    Integer size) {

        log.info("Test 111 ");
        List<RecommendStatistics> statisticsList = new ArrayList<RecommendStatistics>();
        log.info("Test 222 ");
        try {
            DataSource dataSource = GroupHelper.getDataSource("learn_course");
            log.info("Test 333 ");
            if (DataUtils.isNotNullOrEmpty(dataSource)) {
                log.info("  datasource = " + dataSource);
            } else {

            }
            log.info("Test 44 ");
            SimpleJdbcTemplate simpleJdbcTemplate = new SimpleJdbcTemplate(dataSource);
            StringBuilder sql = new StringBuilder();
            if (StringUtil.isNotEmpty(registerNumStart)
                    || StringUtil.isNotEmpty(registerNumEnd)
                    || StringUtil.isNotEmpty(minAmount)
                    || StringUtil.isNotEmpty(maxAmount)) {
                sql.append(" select * from ( ");
            }


            sql.append(
                    " select b.`nick` as nick  ,a.uid as uid,b.mobile as mobile, b.invitation_code as invitationCode,sum(a.registers) as registers ,SUM(a.amount) as amount  ");
            sql.append(" from recommendStatistics a  ");
            sql.append(" JOIN user b on b.id = a.uid  ");

            sql.append("  where 1=1 ");
            if (DataUtils.isNotNullOrEmpty(name)) {
                sql.append(" and b.nick like '%" + name + "%' ");
            }
            if (DataUtils.isNotNullOrEmpty(mobile)) {
                sql.append(" and b.mobile like '%" + mobile + "%' ");
            }
            if (DataUtils.isNotNullOrEmpty(invitationCode)) {
                sql.append(" and b.invitation_code like '%" + invitationCode + "%' ");
            }


            sql.append("  GROUP BY a.uid ORDER BY b.recommend_at desc");
            if (StringUtil.isNotEmpty(registerNumStart)
                    || StringUtil.isNotEmpty(registerNumEnd)
                    || StringUtil.isNotEmpty(minAmount)
                    || StringUtil.isNotEmpty(maxAmount)) {
                sql.append(" ) c  ");
                sql.append("  where 1=1 ");
                if (DataUtils.isNotNullOrEmpty(registerNumStart)) {
                    sql.append(" and c.registers >= '" + registerNumStart + "' ");

                }
                if (DataUtils.isNotNullOrEmpty(registerNumEnd)) {
                    sql.append(" and c.registers <='" + registerNumEnd + "' ");

                }
                if (DataUtils.isNotNullOrEmpty(minAmount)) {
                    sql.append(" and c.amount >= '" + minAmount + "' ");

                }
                if (DataUtils.isNotNullOrEmpty(maxAmount)) {
                    sql.append(" and c.amount <='" + maxAmount + "' ");

                }
            }
            sql.append("    LIMIT " + start + "," + size);

            log.info("Sql " + sql.toString());
            statisticsList = simpleJdbcTemplate.query(sql.toString(),
                    ParameterizedBeanPropertyRowMapper.newInstance(RecommendStatistics.class));
        } catch (Exception e) {
            e.printStackTrace(System.out);
            log.info(e.getMessage());
        }

        log.info("  size  = " + statisticsList.size());
        return statisticsList;
    }


    public static Map<String, Object> getRecommendList(String invitationCode, String alias, String registerNumStart, String registerNumEnd,
                                                       String minDiscount, String maxDiscount, String minSettlement, String maxSettlement,
                                                       Integer recommendStatus, String mobile, String mail, Boolean count) {

        Map<String, Object> params = new HashMap<String, Object>();
        Set<String> tables = new HashSet();
        tables.add("user");
        if (DataUtils.isNotNullOrEmpty(alias)) {
            params.put("user.alias  & like  ", "'%" + alias + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(invitationCode)) {
            params.put("user.invitation_code  & like  ", "'%" + invitationCode + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(mail)) {
            params.put("user.register_mail  & like  ", "'%" + mail + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(mobile)) {
            params.put("user.mobile  & like  ", "'%" + mobile + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(recommendStatus)) {
            params.put("user_recommend.recommend_status ", recommendStatus);

        }

        params.put(" user_recommend.user_id", "user.id");
        tables.add(" user_recommend ");

        if (DataUtils.isNotNullOrEmpty(registerNumStart)) {
            params.put(" user_recommend.recommend_num & >= ", registerNumStart);
        }
        if (DataUtils.isNotNullOrEmpty(registerNumEnd)) {
            params.put(" user_recommend.recommend_num & <= ", registerNumEnd);
        }

        if (DataUtils.isNotNullOrEmpty(minDiscount)) {
            params.put(" user_recommend.discount & >= ", minDiscount);
        }
        if (DataUtils.isNotNullOrEmpty(maxDiscount)) {
            params.put(" user_recommend.discount & <= ", maxDiscount);
        }

        if (DataUtils.isNotNullOrEmpty(minSettlement)) {
            params.put(" user_recommend.ios_amount+user_recommend.android_amount-user_recommend.ios_settlement-user_recommend.android_settlement & >= ", minSettlement);
        }
        if (DataUtils.isNotNullOrEmpty(maxSettlement)) {
            params.put(" user_recommend.ios_amount+user_recommend.android_amount-user_recommend.ios_settlement-user_recommend.android_settlement & <= ", maxSettlement);
        }
        params.put("recommend_flag", 1);
        if (count) {
            params.put("@query", " count(user.id) ");
        } else {
            params.put("@order", "  user_recommend.update_at desc ");
            params.put("@query", " user.id");
        }
        String table = convertTable(tables);
        params.put("@table", table);
        String s = SQLUtil.convert2Sql(params, 0, Integer.MAX_VALUE);
        log.info(" getRecommendList sql is :" + s);
        return params;

    }


    public static Map<String, Object> getDailyStatistcsList(Long startAt, Long endAt, Long uid, Boolean count) {

        Map<String, Object> params = new HashMap<String, Object>();

        if (DataUtils.isNotNullOrEmpty(startAt)) {
            params.put(" static_at & >= ", "'" + startAt + "'");
        }
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            params.put(" static_at & <= ", "'" + endAt + "'");
        }
        if (DataUtils.isNotNullOrEmpty(uid)) {
            params.put(" uid ", "'" + uid + "'");
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", "  static_at desc ");
            params.put("@query", " id");
        }
        params.put("@table", "recommendStatistics");
        return params;
    }


    public static Map<String, Object> getStatisticsGroupParam(String period, Long uid,
                                                              Long startAt, Long endAt) {
        Map<String, Object> params = new HashMap<String, Object>();

        StringBuffer queryParam = new StringBuffer();
        StringBuffer groupParam = new StringBuffer();
        Set<String> tables = new HashSet();
        tables.add("recommendStatistics a ");

        queryParam = queryParam.append("SUM(a.registers) as registers,");
        queryParam = queryParam.append("SUM(a.amount) as amount,");

        if (Period_Week.equals(period)) {
            queryParam = queryParam.append("DATE_FORMAT( FROM_UNIXTIME ( a.static_at / 1000),'%Y%u' ) as week ");

        } else {
            queryParam = queryParam.append("DATE_FORMAT( FROM_UNIXTIME ( a.static_at / 1000),'%Y%m' ) as week ");
        }

        groupParam = groupParam.append("week ");

        if (startAt != null) {
            params.put("a.static_at & >= ", startAt);
        }
        if (endAt != null) {
            params.put("a.static_at & <= ", endAt);

        }
        params.put("a.uid", "'" + uid + "'");
        params.put("@query", queryParam.toString());
        params.put("@group", groupParam.toString());
        String table = convertTable(tables);
        params.put("@order", " week desc");
        params.put("@table", table);

        String s = SQLUtil.convert2Sql(params, 0, Integer.MAX_VALUE);
        log.info("getStatisticsGroupParam sql is  " + s);
        return params;

    }


    public static String getStatisticsDate(String period, String week, int i, Long startAt,
                                           Long endAt, int size)
            throws ParseException {

        String date = "";
        if (Period_Week.equals(period)) {
            Long weekCount = Long.valueOf(week.substring(4, 6));
            Long weekEndAt = 0L;
            Long weekStartAt = 0L;
            Long year = Long.valueOf(week.substring(0, 4));
            log.info(" year is = " + year);
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String time = year + "-01-01 00:00:00";
            log.info(" time = " + time);
            Long freYear = format.parse(time).getTime();
            log.info(" freYear = " + freYear + " weekcount = " + weekCount);
            Long a = weekCount * 7 * 24 * 3600 * 1000 + 2 * 24 * 3600 * 1000;
            log.info(" a= " + a);
            weekEndAt = a + freYear;
            log.info(" weekEndAt=  " + weekEndAt);
            weekStartAt = weekEndAt - 6 * 24 * 3600 * 1000;
            if (i == 0) {
                if (null != startAt) {
                    weekStartAt = startAt;
                }

            }
            if (i == size - 1) {

                if (null != endAt) {
                    weekEndAt = endAt;
                }
            }

            date = getDate(weekStartAt) + "-" + getDate(weekEndAt);
        } else {
            Long year = Long.valueOf(week.substring(0, 4));
            Long monthCount = Long.valueOf(week.substring(4, 6));
            date = year + "年" + monthCount + "月";
        }
        return date;
    }


    public static String getDate(Long time) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String date = "";
        if (null != time) {
            date = dateFormat.format(new Date(time));
        }
        return date;
    }
}
