package com.ptteng.academy.admin.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class SplitLstUtils {

    private static final Integer DEFAULT_SIZE = 10;

    @SuppressWarnings("unchecked")
    public static<T> List<T> fastSplitLst(List<T> dataList, Integer size, Integer pageNo){

        if(dataList==null||dataList.size()==0){
            return null;
        }
        if(size==null||size<=0){
            size = DEFAULT_SIZE;
        }
        Integer sizeChecker;
        if (dataList.size() % size == 0) {
            sizeChecker = dataList.size() / size;
        }else {
            sizeChecker = dataList.size() / size + 1;
        }
        if (pageNo > sizeChecker) {
            return new ArrayList<T>();
        }
        List<List<T>> resultList = (List<List<T>>) new ArrayList<T>();
        Integer lstSize = dataList.size()%size==0?dataList.size()/size:dataList.size()/size+1;
        for (int a = 0; a<lstSize;a++) {
            if(a==lstSize-1){
                resultList.add((List<T>)new ArrayList<Object>(dataList.subList(a*size, dataList.size())));
            }else{
                resultList.add((List<T>)new ArrayList<Object>(dataList.subList(a*size, (a+1)*size)));
            }
        }
        return resultList.get(pageNo-1);
    }

    public static<T> List<T> splitLst(List<T> dataList,Integer size,Integer pageNo){
        if(dataList==null||dataList.size()==0){
            return new ArrayList<T>();
        }
        if(size==null||size<=0){
            size = DEFAULT_SIZE;
        }
        Integer sizeChecker;
        if (dataList.size() % size == 0) {
            sizeChecker = dataList.size() / size;
        }else {
            sizeChecker = dataList.size() / size + 1;
        }
        if (pageNo > sizeChecker) {
            return new ArrayList<T>();
        }

        LinkedList<List<T>> resultList = (LinkedList<List<T>>) new LinkedList<T>();
        Integer lstSize = dataList.size()%size==0?dataList.size()/size:dataList.size()/size+1;
        for(int i=0;i<lstSize;i++){
            if(i==lstSize-1){
                resultList.addLast(new ArrayList<T>(dataList.subList(i*size, dataList.size())));
            }else{
                resultList.addLast(new ArrayList<T>(dataList.subList(i*size, (i+1)*size)));
            }
        }
        return resultList.get(pageNo-1);
    }

}