package com.ptteng.academy.admin.util;

import com.ptteng.academy.common.service.SmsService;
import com.ptteng.academy.user.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;

public class MsgTest {

    private static ExecutorService service = Executors.newFixedThreadPool(100);

    @Autowired
    private static UserService userService;
    @Autowired
    private static SmsService smsService;


    public static void main(String[] args) {


    }

    public int sendMsg(List<String> receivers, final String content) {


        long begin = System.nanoTime();
        AtomicInteger aInt = new AtomicInteger(0);
        List<Future<Integer>> futures = new ArrayList<>();

        for (int i = 0; i < receivers.size(); i++) {

            final String mobile = receivers.get(0);
            Future<Integer> future = service.submit(new Callable<Integer>() {

                @Override
                public Integer call() throws Exception {

                    Thread.sleep(200);

                    int resultStatus = sendMsg(mobile, content);
                    System.out.println("接收者【" + mobile + "】,发送结果【" + resultStatus + "】");
                    return resultStatus;

                }

            });
            futures.add(future);
        }

        System.out.println("-----------------------" + (System.nanoTime() - begin) / 1000_000d + "-----------------------");
        //循环接收发送结果，相当于一个使线程同步的过程，这个过程是比较耗时的
        for (int i = 0; i < futures.size(); i++) {
            try {
                int resultStatus = futures.get(i).get();
                if (resultStatus == 0) {//发送成功
                    aInt.incrementAndGet();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("发送消息结束，耗时：" + (System.nanoTime() - begin) / 1000_000d);
        return aInt.get();


    }

    //完成发送消息
    private int sendMsg(String receiver, String content) {
//        if (receiver % 2 == 0) {//模拟被2整除，即为发送成功
//            return 0;
//        }
        return 1;
    }


}
