package com.ptteng.academy.admin.controller;

import com.gemantic.common.util.MyListUtil;
import com.gemantic.common.util.StringUtil;
import com.ptteng.academy.admin.exception.MyException;
import com.ptteng.academy.admin.model.Manager;
import com.ptteng.academy.admin.model.School;
import com.ptteng.academy.admin.service.ManagerService;
import com.ptteng.academy.admin.service.SchoolService;
import com.ptteng.academy.admin.util.*;
import com.ptteng.academy.course.model.*;
import com.ptteng.academy.course.service.*;
import com.ptteng.academy.document.model.UserFavoriteRelation;
import com.ptteng.academy.document.service.UserFavoriteRelationService;
import com.ptteng.academy.user.model.Member;
import com.ptteng.academy.user.model.*;
import com.ptteng.academy.user.model.User;
import com.ptteng.academy.user.model.UserMemberRelation;
import com.ptteng.academy.user.model.UserOpenidRelation;
import com.ptteng.academy.user.model.UserRecommend;
import com.ptteng.academy.user.service.MemberService;
import com.ptteng.academy.user.service.*;
import com.ptteng.academy.user.service.UserMemberRelationService;
import com.ptteng.academy.user.service.UserOpenidRelationService;
import com.ptteng.academy.user.service.UserRecommendService;
import com.ptteng.academy.user.service.UserService;
import com.ptteng.common.storage.util.ImgStorageUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.FileUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * User  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */

@Controller
public class UserController {
    private static final Log log = LogFactory.getLog(UserController.class);
    /**
     *
     */
    @Autowired
    private UserService userService;
    @Autowired
    private CookieUtil cookieUtil;
    @Autowired
    private ManagerService managerService;
    @Autowired
    private SchoolService schoolService;
    @Autowired
    private MemberService memberService;
    @Autowired
    private UserMemberRelationService userMemberRelationService;
    @Autowired
    private UserFavoriteRelationService userFavoriteRelationService;
    @Autowired
    private ImgStorageUtil imgStorageUtil;
    @Autowired
    private UserOpenidRelationService userOpenidRelationService;
    @Autowired
    private LoginRecordService loginRecordService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private LessonService lessonService;
    @Autowired
    private SubjectService subjectService;
    @Autowired
    private PeriodService periodService;
    @Autowired
    private UnitService unitService;
    @Autowired
    private UesrCourseRelationService userCourseRelationService;
    @Autowired
    private UserRecommendService userRecommendService;

    //1、用户详情
    @RequestMapping(value = "/a/u/user/{id}", method = RequestMethod.GET)
    public String getUserJson(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {
        log.info("get data : id= " + id);
        try {
            User user = userService.getObjectById(id);
            log.info("get user data is " + user);

            if (null == user) {
                log.info("user not exist");
                model.addAttribute("code", -2000);
                return "/common/success";
            } else {
                log.info("get user : " + user);
            }
            if (null == user.getSchoolId()) {
                log.info("This user not a student");
            } else {
                School school = schoolService.getObjectById(user.getSchoolId());
                if (null == school) {
                    model.addAttribute("code", -7011);
                    return "/common/success";
                }
                user.setSchoolName(school.getName());
            }

            model.addAttribute("code", 0);
            model.addAttribute("user", user);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get user error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/academy-user-service/user/json/userDetailJson";
    }


    //2、冻结解冻用户
    @RequestMapping(value = "/a/u/freeze/user/{id}", method = RequestMethod.PUT)
    public String updateUserJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                 @PathVariable Long id, Integer status) throws Exception {

        log.info("update user : userId is= " + id + " status : " + status);

        try {
            User user = userService.getObjectById(id);
            if (user == null) {
                model.addAttribute("code", 2);
                return "/common/success";
            }

            if (User.STATUS_OFF != status && User.STATUS_NORMAL != status) {
                model.addAttribute("code", -1001);
                return "/common/success";
            }

            user.setStatus(status);
            userService.update(user);
            log.info("update user status " + status + " success ");

            model.addAttribute("code", 0);
            model.addAttribute("user", user);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update user status error,id is  " + id);
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }


    //3、用户列表
    @RequestMapping(value = "/a/u/user/list", method = RequestMethod.GET)
    public String getMultiUserJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer status,
                                   String alias, Integer grade, String mail, String mobile, Integer scoreStart,
                                   Integer scoreEnd, String location, Integer page, Integer size, Long schoolId, String className, String memberName, Integer isMember,
                                   Integer videoWatchTimesStart, Integer videoWatchTimesEnd, Integer userType, Integer loginTimesStart, Integer loginTimesEnd) throws Exception {

        List<Long> idList = new ArrayList();
        Boolean next = false;

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }


        log.info("get user list by : status = " + status + " alias = " + alias + " grade = " + grade + " mail = " + mail +
                " mobile = " + mobile + " minScore = " + scoreStart + " maxScore = " + scoreEnd + " location = " + location + " page = "
                + page + " size = " + size + " schoolId = " + schoolId + " className = " + className + " memberId = " + memberName);
        //学校账号仅能查看该学校学生
        Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID));
        Long mSchoolId = managerService.getObjectById(uid).getSchoolId();
        if (mSchoolId == null) {
            log.info(" Not a school manager");
        } else {
            schoolId = mSchoolId;
            log.info(" Is a school manager, schoolId is " + schoolId);
        }


//        if (memberId != null ) {
//            Map<String,Object> param = DynamicUtil.getMemberList()
//            memberService.getIdsByDynamicCondition();
//        }


        try {
            //搜索会员类型
            //全部
            List<Long> uids = null;
            // Integer isMember = null;
            Integer total = 0;


            List<Integer> isMembers = new ArrayList<>();
            if (DataUtils.isNotNullOrEmpty(isMember)) {

                if (!isMember.equals(User.IS_MEMBER) && !isMember.equals(User.IS_NOT_MEMBER) && !isMember.equals(4)) {
                    model.addAttribute("code", -1001);
                    return "/common/success";
                }
                switch (isMember) {
                    case User.IS_MEMBER:
                        isMembers.add(1);
                        break;
                    case User.IS_NOT_MEMBER:
                        isMembers.add(2);
                        break;
                    case 4:
                        isMembers.add(1);
                        isMembers.add(2);
                        break;
                }
            }


//            if (memberName == null) {
//                log.info("get all user");
//            } else {
//                switch (memberName) {
//                    //非会员-搜user表
//                    case Member.NOT_MEMBER:
//                        log.info("Get non-member");
//                        isMember = User.IS_NOT_MEMBER;
//                        break;
//                    //过期会员-搜user_member_relation表
//                    case Member.EXPRIED_MEMBER:
//                        log.info("Obtain an expired member");
//                        //搜索过期订单
//                        Map<String, Object> param = DynamicUtil.getUidListByUserMemberRelation(null, null, User.IS_EXPRIED_MEMBER);
//                        uids = userMemberRelationService.getIdsByDynamicCondition(UserMemberRelation.class, param, 0, Integer.MAX_VALUE);
//                        log.info("uids is " + uids);
//
//                        break;
//                    //正常套餐会员
//                    default:
//                        log.info("Get a member of type " + memberName);
//                        //搜搜套餐会员
//                        Map<String, Object> param2 = DynamicUtil.getUidListByUserMemberRelation(null, memberName, User.IS_MEMBER);
//                        uids = userMemberRelationService.getIdsByDynamicCondition(UserMemberRelation.class, param2, 0, Integer.MAX_VALUE);
//                        log.info("uids is " + uids);
//
//                        isMember = User.IS_MEMBER;
//                        break;
//                }
//            }

//            if (uids != null && uids.size() == 0) {
//                List<User> userList = new ArrayList<>();
//                model.addAttribute("code", 0);
//                model.addAttribute("next", false);
//                model.addAttribute("total", total);
//                model.addAttribute("totalPage", 1);
//                model.addAttribute("userList", userList);
//                return "/academy-user-service/user/json/userListJson";
//            }
            Map<String, Object> params = DynamicUtil.getUserList(alias, mail, mobile, grade, status, scoreStart, scoreEnd, location,
                    schoolId, className, isMembers, uids, videoWatchTimesStart, videoWatchTimesEnd, userType, loginTimesStart, loginTimesEnd);
            idList = userService.getIdsByDynamicCondition(User.class, params, start, size);
            log.info("user idList is " + idList);
            List<User> userList = userService.getObjectsByIds(idList);
            log.info("get  user data is " + userList.size());

            //获取用户所属学校id列表
            List<Long> schoolIds = new ArrayList<>();
            Map<Long, String> uid_memberName = new HashMap<>();
            for (User user : userList) {
                if (user.getIsMember().equals(User.IS_MEMBER)) {
                    List<Long> rids = userMemberRelationService.getUserMemberRelationIdsByUid(user.getId(), 0, 1);

                    if (CollectionUtils.isNotEmpty(rids)) {

                        UserMemberRelation relation = userMemberRelationService.getObjectById(rids.get(0));
                        if (User.IS_MEMBER == relation.getStatus()) {
                            uid_memberName.put(user.getId(), relation.getName());
                        } else {
                            uid_memberName.put(user.getId(), "过期会员");
                        }
                    }
                }

                if (user.getSchoolId() != null) {
                    schoolIds.add(user.getSchoolId());
                }
            }

            log.info("get  user schoolIds size is " + schoolIds.size());
            //获取学校信息
            if (schoolIds.size() > 0) {
                List<School> schoolList = schoolService.getObjectsByIds(schoolIds);
                Map<Long, String> schoolNames = new HashMap<>();
                for (School school : schoolList) {
                    schoolNames.put(school.getId(), school.getName());
                }
                //设置用户学校名称
                for (User user : userList) {

                    if (user.getSchoolId() != null) {
                        user.setSchoolName(schoolNames.get(user.getSchoolId()));
                    }
                }

            }


            Integer userCount = userService.countUserIds();

            log.info("   total = " + userCount);
            model.addAttribute("userCount", userCount);
            List<Long> usercountIds = userService.getIdsByDynamicCondition(User.class, params, 0, Integer.MAX_VALUE);
            userCount = usercountIds.size();
            Integer totalPage = (((userCount - 1)) / size) + 1;
            log.info("   totalPage = " + totalPage);

            if (idList != null && idList.size() > 0) {
                if (size.equals(idList.size())) {
                    next = true;
                    idList = idList.subList(0, size);
                }
            }

            total = userService.countUserIds();

            model.addAttribute("code", 0);
            model.addAttribute("next", next);
            model.addAttribute("total", total);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("userList", userList);
            model.addAttribute("uid_memberName", uid_memberName);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get user list error");
            model.addAttribute("code", -1);
        }

        return "/academy-user-service/user/json/userListJson";
    }

    //修改手机号
    @RequestMapping(value = "/a/u/user/phone/{id}", method = RequestMethod.PUT)
    public String updateUserPhoneJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, String mobile, Long schoolId, @PathVariable Long id) throws Exception {

        //获取用户id
        log.info("phone userId is " + id);
        //通过用户id查询user表中该条信息

        User user = new User();
        user = userService.getObjectById(id);
        if (DataUtils.isNullOrEmpty(user)) {
            model.addAttribute("code", -2000);
            return "/common/success";
        }
        log.info("mobile is " + mobile + ", schoolId is " + schoolId);
        if (StringUtil.isNotEmpty(mobile)) {
            user.setMobile(mobile);
        }
        if (DataUtils.isNotNullOrEmpty(schoolId)) {
            user.setSchoolId(schoolId);
        }
        boolean update = userService.update(user);
        log.info("update user result is " + update);

        //更新该条信息
        model.addAttribute("code", 0);
        return "/common/success";
    }

    //添加逆袭豆
    @RequestMapping(value = "/a/u/user/score/{id}", method = RequestMethod.PUT)
    public String addScoreJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long score, Long type, @PathVariable Long id) throws Exception {
        //获取用户id
        log.info("get  user data is " + id + "add");
        //通过用户id查询user表中该条信息
        Long userScore = null;
        if (null != id && null != score && null != type) {
            User user = new User();
            user = userService.getObjectById(id);
            if (type == 1) {
                userScore = user.getScore() + score;
            }
            if (type == 0) {
                userScore = user.getScore() - score;
            }
            if (userScore < 0) {
                model.addAttribute("code", -9200);
                return "/common/success";
            }
            user.setScore(userScore);
            userService.update(user);
        } else {
            model.addAttribute("code", -1000);
            return "/common/success";
        }
        //更新该条信息

        model.addAttribute("code", 0);
        model.addAttribute("score", userScore);

        return "/academy-user-service/user/json/userSign";
    }

    //会员详情
    @RequestMapping(value = "/a/u/user/member/{id}", method = RequestMethod.GET)
    public String getUserMemberJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {
        log.info("get member data : id= " + id);

        try {
            User user = userService.getObjectById(id);
            log.info("get user data is " + user);

            if (null == user) {
                model.addAttribute("code", -2000);
                return "/common/success";
            }

            List<Long> memeberIds = userMemberRelationService.getUserMemberRelationIdsByUid(id, 0, Integer.MAX_VALUE);
            List<UserMemberRelation> relations = userMemberRelationService.getObjectsByIds(memeberIds);
            if (CollectionUtils.isEmpty(relations)) {
                log.info("user not member");
                model.addAttribute("code", -2200);
                return "/common/success";
            }

            UserMemberRelation endRelation = relations.get(0);
            model.addAttribute("vipEnd", endRelation.getEndAt());
            if (User.IS_MEMBER == endRelation.getStatus()) {
                model.addAttribute("memberName", endRelation.getName());
            } else {
                model.addAttribute("memberName", "过期会员");
            }
            UserMemberRelation beginRelation = relations.get(relations.size() - 1);
            model.addAttribute("vipBegin", beginRelation.getStartAt());
            Long end = endRelation.getEndAt();
            Date date = new Date();
            long time = date.getTime();
            Long deadTime = (end - time) / (86400000L);
            model.addAttribute("deadTime", deadTime);

            BigDecimal total = BigDecimal.ZERO;
            for (UserMemberRelation relation : relations) {
                log.info("-------------------------------------------------------------");
                BigDecimal i = relation.getPrice();
                total = total.add(i);
                log.info(total);

                log.info("-------------------------------------------------------------");
            }

            model.addAttribute("totalPrice", total);
//            List<Long> rids = loginRecordService.getLoginRecordIdsByUid(id, 0, Integer.MAX_VALUE);
//            List<LoginRecord> loginRecords = loginRecordService.getObjectsByIds(rids);

            model.addAttribute("code", 0);
            model.addAttribute("user", user);
            //model.addAttribute("relations", relations);
            //model.addAttribute("loginRecords", loginRecords);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get user error,id is  " + id);
            model.addAttribute("code", -1);
        }


        return "/academy-user-service/user/json/userMember";
    }

    //购买记录
    @RequestMapping(value = "/a/u/order/list", method = RequestMethod.GET)
    public String getUserOrderListJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long id,
                                       Integer page, Integer size) throws Exception {
        log.info("get member data : id= " + id);

        try {
            User user = userService.getObjectById(id);
            log.info("get user data is " + user);

            if (null == user) {
                model.addAttribute("code", -2000);
                return "/common/success";
            }

            List<Long> memeberIds = userMemberRelationService.getUserMemberRelationIdsByUid(id, 0, Integer.MAX_VALUE);
            List<UserMemberRelation> relations = userMemberRelationService.getObjectsByIds(memeberIds);

            if (relations.size() > 0) {
                UserMemberRelation endRelation = relations.get(0);
                model.addAttribute("vipEnd", endRelation.getEndAt());
                if (User.IS_MEMBER == endRelation.getStatus()) {
                    model.addAttribute("memberName", endRelation.getName());
                } else {
                    model.addAttribute("memberName", "过期会员");
                }
                UserMemberRelation beginRelation = relations.get(relations.size() - 1);
                model.addAttribute("vipBegin", beginRelation.getStartAt());
                Long end = endRelation.getEndAt();
                Date date = new Date();
                long time = date.getTime();
                Long deadTime = (end - time) / (86400000L);
                model.addAttribute("deadTime", deadTime);

                BigDecimal total = BigDecimal.ZERO;
                for (UserMemberRelation relation : relations) {
                }

                model.addAttribute("totalPrice", total);

            } else {
                log.info("user not member");
                model.addAttribute("code", -2200);
                return "/common/success";
            }

//            List<Long> rids = loginRecordService.getLoginRecordIdsByUid(id, 0, Integer.MAX_VALUE);
//            List<LoginRecord> loginRecords = loginRecordService.getObjectsByIds(rids);

            model.addAttribute("code", 0);
            model.addAttribute("user", user);
            model.addAttribute("relations", relations);
            //model.addAttribute("loginRecords", loginRecords);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get user error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/academy-user-service/user/json/userOrder";
    }

    //登陆记录
    @RequestMapping(value = "/a/u/user/login/{uid}", method = RequestMethod.GET)
    public String getUserLoginJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long uid) throws Exception {
        User user = userService.getObjectById(uid);
        try {
            List<Long> rids = loginRecordService.getLoginRecordIdsByUid(uid, 0, Integer.MAX_VALUE);
            List<LoginRecord> loginRecords = loginRecordService.getObjectsByIds(rids);

            model.addAttribute("code", 0);
            model.addAttribute("user", user);
//            model.addAttribute("relations", relations);
            model.addAttribute("loginRecords", loginRecords);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get user error,id is  " + uid);
            model.addAttribute("code", -1);
        }

        model.addAttribute("code", 0);
        return "/academy-user-service/user/json/userLogin";
    }

    /**
     * 无需修改名字的文件尾缀，<b>必须有序存放</b> <br>
     * 例如："apk" < "jpeg" < "jpg"
     */
    private static final String[] suffixs = {"apk", "jpeg", "jpg", "png"};

    /**
     * 文件上传接口，包括图片，excel，apk等文件
     *
     * @param request
     * @param response
     * @param model
     * @param file
     * @param module
     * @return
     */
    @RequestMapping(value = "/a/u/file/{module}", method = RequestMethod.POST)
    public String uploadFile(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                             @RequestParam MultipartFile file, @PathVariable String module) {
        log.info("controller uploadFile begin...");
        if (StringUtils.isBlank(module)) {
            module = "common";
        }
        log.info("argument module is: " + module + ", file name is: " + file.getOriginalFilename());
        try {
            /* 第一步、文件上传前的准备工作 */
            long size = file.getSize();
            log.info("upload file size is: " + size + " bytes");
            String suffix = FileUtil.getFileExtension(file.getOriginalFilename());
            log.info("upload file suffix is: " + suffix);
            String newFileName, oldFileName = file.getOriginalFilename();
            if (Arrays.binarySearch(suffixs, suffix) >= 0) { // include
                newFileName = oldFileName;
            } else {
                newFileName = UUID.randomUUID().toString() + "." + suffix;
            }
            log.info("the newFileName is: " + newFileName);

            /* 第二步、上传文件 */
            /* 临时目录 */
            String tempDirStr = ParseExcel.FILE_PATH + "/" + module;
            log.info("tempDirStr is: " + tempDirStr);
            File tempDir = new File(tempDirStr);
            if (tempDir.exists()) {
                log.info("temp dir has exists, do not need to mkdir");
            } else {
                log.info("temp dir not exists");
                tempDir.mkdirs();
            }
            /* 临时文件 */
            String tempFileStr = tempDirStr + "/" + newFileName;
            log.info("tempFileStr is: " + tempFileStr);
            File tempFile = new File(tempFileStr);
            if (tempFile.exists()) {
                log.info("temp file has exists, do not need to touch");
            } else {
                log.info("temp file not exists");
                tempFile.createNewFile();
            }
            file.transferTo(tempFile);
            String url;

            /* 第三步、分情况上传并删除临时文件 */
            if (ParseExcel.EXCEL_SUFFIX[0].equals(suffix) || ParseExcel.EXCEL_SUFFIX[1].equals(suffix)
                    || ParseExcel.EXCEL_SUFFIX[2].equals(suffix)) {
                log.info("excel file need to parse, temporarily not to delete");
                url = tempFileStr;
            } else {
                url = imgStorageUtil.imgStorage(module, module + "/" + newFileName, tempFileStr);
                log.info("upload success, and new file name is: " + newFileName
                        + ", and new file temp dir is: " + tempDirStr + ", and access url is: " + url);
                log.info("other file need to delete");
                tempFile.delete();
                log.info(oldFileName + " delete success");
            }
            model.addAttribute("url", url);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            log.error("uploadFile error...", t);
            model.addAttribute("code", -1);
            return "/common/img";
        }
        log.info("controller uploadFile end...");
        return "/common/img";
    }

    /**
     * 批量导入用户
     *
     * @param request
     * @param response
     * @param model
     * @param excelUrl
     * @param isMember; 是否设置会员
     * @return
     */

    @RequestMapping(value = "/a/u/user/bulkimport", method = RequestMethod.POST)
    public String parseUserExcel(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                 String excelUrl, Integer isMember, Long memberId, Long schoolId) {
        log.info("arguments: excelUrl = [" + excelUrl + "], isMember = [" + isMember + "], schoolId = [" + schoolId + "]" + " membeId = " + memberId);
        String img = "http://learn-10047330.file.myqcloud.com/article/e555c361-cb58-48c1-854f-9c79003b763c.png";

        try {
            //学校账户仅能导入本校学生
            Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID));

            Long sid = managerService.getObjectById(uid).getSchoolId();
            String schoolName = null;
            if (sid == null) {
                log.info(" Not a school manager");
                if (schoolId == null) {
                    model.addAttribute("code", -7011);
                    return "data/json";
                }
            } else {
                schoolId = sid;
                log.info(" Is a school manager, schoolId is " + schoolId);
                schoolName = schoolService.getObjectById(schoolId).getName();
            }



            /* 第一步、入参的非空校验 */
            if (StringUtil.isEmpty(excelUrl)) {
                model.addAttribute("code", -1007);
                return "/data/json";
            }
            Integer memberStatus = User.IS_NOT_MEMBER;
            Member member = null;
            if (isMember == null || isMember != User.IS_MEMBER) {
                log.info(" Do not set a member ");
            } else {
                log.info(" Do set a member ");
                memberStatus = User.IS_MEMBER;
                //获取全年套餐id
                // Map<String, Object> param = DynamicUtil.getMemberList(null, String.valueOf(12), String.valueOf(12), null, null, null, null, 1, false);
                if (DataUtils.isNullOrEmpty(memberId)) {
                    model.addAttribute("code", -9109);
                    return "/common/success";
                }
                member = memberService.getObjectById(memberId);
                log.info("member name is " + member.getName());
                if (DataUtils.isNullOrEmpty(member)) {
                    model.addAttribute("code", -1);
                    return "/common/success";
                }
            }

            /** 第二步、解析excel表 */
            List<User> userList = null;
            try {
                userList = ParseExcel.parseUserExcel(excelUrl);
            } catch (Exception e) {

                if (e instanceof MyException) {
                    MyException me = (MyException) e;
                    model.addAttribute("code", me.getErrorCode());
                    return "/common/success";
                }
            }
            //尝试更换解码方式；
            if (CollectionUtils.isEmpty(userList)) {
                log.info("file is csv");
                userList = ParseCSV.parseUserCSV(excelUrl);
            }
            if (CollectionUtils.isEmpty(userList)) {
                model.addAttribute("code", -1008);
                return "/data/json";
            }
            List<String> mobileList = new ArrayList<>();
            List<String> mailList = new ArrayList<>();

            for (User user : userList) {

                if (DataUtils.isNotNullOrEmpty(user.getMobile())) {
                    mobileList.add(user.getMobile());
                    log.info("mobile is " + user.getMobile());
                }
                if (DataUtils.isNotNullOrEmpty(user.getMail())) {
                    mailList.add(user.getMail());
                }
                user.setSchoolId(schoolId);
                user.setImg(img);
                user.setSchoolName(schoolName);
                user.setCreateBy(uid);
                user.setUpdateBy(uid);
                user.setScore(0L);
                user.setRegisterAt(System.currentTimeMillis());
                user.setLastLoginAt(System.currentTimeMillis());
                user.setStatus(1);
                user.setWrongCount(0);
                user.setConsecutive(0);
                user.setSignHighest(0);
                user.setSign(0);
                user.setIsVisit(User.RECOMMEND_UNVISTIED);
                user.setPoststatus(2);
                user.setSignTotal(0);
                user.setHollowStatus(1);
                user.setIsRead(2);
                user.setIsMember(memberStatus);
                user.setLoginTimes(0);
                user.setVideoWatchTimes(0);
                user.setInvitationCodeStatus(1);
            }
            //检查是否有重复手机号
            if (CommonUtil.repeatValues(mobileList)) {
                model.addAttribute("code", -1009);
                return "common/success";
            }
            if (CommonUtil.repeatValues(mailList)) {
                model.addAttribute("code", -1010);
                return "common/success";
            }
            log.info("mobileList size " + mobileList);
            log.info("mailList size " + mailList);
            //检查手机是否注册 (user表和 user_openid_relation表都查)
            Map<String, Object> userMobileParam = DynamicUtil.getUserIdByMobileList(mobileList);
            List<Long> userIdsByMobile = userService.getIdsByDynamicCondition(User.class, userMobileParam, 0, Integer.MAX_VALUE);
            if (CollectionUtils.isNotEmpty(userIdsByMobile)) {
                log.info("check mobile1");
                List<User> users = userService.getObjectsByIds(userIdsByMobile);
                log.info("users is " + users);
                List<String> alreadyMobileList = MyListUtil.getList(User.class.getDeclaredField("mobile"), users);
                model.addAttribute("openids", alreadyMobileList);
                model.addAttribute("code", -2003);
                return "/academy-user-service/user/json/userOpenidList";
            }

            Map<String, Object> mobileParam = DynamicUtil.getOpenidByMobileList(mobileList, UserOpenidRelation.TYPE_MOBILE);
            List<Long> oIdsMobile = userOpenidRelationService.getIdsByDynamicCondition(UserOpenidRelation.class, mobileParam, 0, Integer.MAX_VALUE);
            log.info("the excel openid existed , oIds is " + oIdsMobile);
            if (oIdsMobile.size() > 0) {
                log.info("check mobile2");
                List<UserOpenidRelation> openidList = userOpenidRelationService.getObjectsByIds(oIdsMobile);
                List<String> openids = new ArrayList<>();
                log.info("openidList is " + openidList);
                for (UserOpenidRelation openidRelation : openidList) {
                    openids.add(openidRelation.getOpenid());
                }
                model.addAttribute("openids", openids);
                model.addAttribute("code", -2003);
                return "/academy-user-service/user/json/userOpenidList";
            }

            //检查邮箱是否注册
            Map<String, Object> mailParam = DynamicUtil.getOpenidByMobileList(mailList, UserOpenidRelation.TYPE_MAIL);
            List<Long> oIdsMail = userOpenidRelationService.getIdsByDynamicCondition(UserOpenidRelation.class, mailParam, 0, Integer.MAX_VALUE);
            log.info("the excel openid existed , oIds is " + oIdsMail);

            if (oIdsMail.size() > 0) {
                List<UserOpenidRelation> openidList = userOpenidRelationService.getObjectsByIds(oIdsMail);
                List<String> openids = new ArrayList<>();
                for (UserOpenidRelation openidRelation : openidList) {
                    openids.add(openidRelation.getOpenid());
                    openidRelation.getUid();
                }
                model.addAttribute("openids", openids);
                model.addAttribute("code", -2010);
                return "/academy-user-service/user/json/userOpenidList";
            }
            log.info("======== now generate invitationCode =========");
            //批量生成邀请码
            List<String> invitationCodes = AcademyUserUtil.getInvitations(userList.size());
            log.info("invitationCodes  is " + invitationCodes.size());
            for (int i = 0; i < userList.size(); i++) {
                userList.get(i).setInvitationCode(invitationCodes.get(i));
            }
            List<User> userListResult = userService.insertList(userList);
            log.info("insert user success, user size is " + userListResult.size());

            List<UserOpenidRelation> userOpenidRelationList = new ArrayList<>();
            List<UserMemberRelation> userMemberRelationsList = new ArrayList<>();
            Long now = System.currentTimeMillis();
            log.info("generate userMember relations for users, size is  " + userListResult.size());
            //插入openid，设置会员
            for (User user : userListResult) {
                if (DataUtils.isNotNullOrEmpty(user.getMobile())) {
                    UserOpenidRelation userOpenidRelation = new UserOpenidRelation();
                    userOpenidRelation.setUid(user.getId());
                    userOpenidRelation.setOpenid(user.getMobile());
                    userOpenidRelation.setType(UserOpenidRelation.TYPE_MOBILE);
                    userOpenidRelationList.add(userOpenidRelation);
                }
                if (DataUtils.isNotNullOrEmpty(user.getMail())) {
                    UserOpenidRelation userOpenidRelation = new UserOpenidRelation();
                    userOpenidRelation.setUid(user.getId());
                    userOpenidRelation.setOpenid(user.getMail());
                    userOpenidRelation.setType(UserOpenidRelation.TYPE_MAIL);
                    userOpenidRelationList.add(userOpenidRelation);
                }


                //设置会员
                if (member != null) {
                    UserMemberRelation userMemberRelation = new UserMemberRelation();
                    userMemberRelation.setUid(user.getId());
                    userMemberRelation.setName(member.getName());
                    userMemberRelation.setPrice(member.getPrice());
                    userMemberRelation.setPeriod(member.getPeriod());
                    userMemberRelation.setStatus(User.IS_MEMBER);
                    userMemberRelation.setStartAt(now);
                    userMemberRelation.setCacheAmountLimit(member.getCacheAmountLimit());
                    Date startDate = new Date(now);
                    Date endDate = DateUtils.addMonths(startDate, member.getPeriod().intValue());
                    Long endAt = endDate.getTime();
                    userMemberRelation.setEndAt(endAt);
                    userMemberRelationsList.add(userMemberRelation);
                    log.info(" user " + uid + " member startAt = " + getDate(now) + " endAt = " + getDate(endAt));
                }
            }
            userOpenidRelationService.insertList(userOpenidRelationList);
            userMemberRelationService.insertList(userMemberRelationsList);

            model.addAttribute("userList", userList);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            log.error("parseVenderTaskExcel error...", t);
            model.addAttribute("code", -1);
            return "/data/json";
        }
        log.info("controller parseUserExcel end...");
        return "/academy-user-service/user/json/userListJson";
    }


    private static String getDate(Long time) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = "";

        if (null != time) {
            date = dateFormat.format(new Date(time));
        }
        return date;
    }

    //学习记录
    @RequestMapping(value = "/a/u/task/collection/list", method = RequestMethod.GET)
    public String getCollectionListJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page, Integer size, Long uid) {

        List<Long> taskIds = new ArrayList<>();
        List<Task> taskList = new ArrayList<>();
        List<Long> totalIds = new ArrayList<>();
        List<UserFavoriteRelation> relationList = new ArrayList<>();


        if (null == page) {
            page = 1;
        }
        if (null == size) {
            size = 10;
        }

        int start = (page - 1) * size;
        Boolean next = false;

        try {

            log.info("======= 列表 获取 单个 用户的学习记录 =======");
            List<Long> relationIds = userFavoriteRelationService.getUserFavoriteRelationIdByUidAndTargetTypeAndTypeAndStatus(uid, UserFavoriteRelation.TARGET_TYPE_TASK, UserFavoriteRelation.TYPE_VIEW_RECORD, UserFavoriteRelation.STATUS_ACTIVE, start, size);


            relationList = userFavoriteRelationService.getObjectsByIds(relationIds);
            taskIds = MyListUtil.getFieldValueListFromModelList(relationList, true, UserFavoriteRelation.class.getDeclaredField("targetId"));

            taskList = taskService.getObjectsByIds(taskIds);

            // periodId_alias   lessonId_alias   subjectId_alias
            List<Long> periodIdsR = MyListUtil.getDistinctList(Task.class.getDeclaredField("periodId"), taskList);
            List<Long> lessonIdsR = MyListUtil.getDistinctList(Task.class.getDeclaredField("lessonId"), taskList);
            List<Long> subjectIdsR = MyListUtil.getDistinctList(Task.class.getDeclaredField("subjectId"), taskList);

            List<Period> periodList = periodService.getObjectsByIds(periodIdsR);
            List<Lesson> lessonList = lessonService.getObjectsByIds(lessonIdsR);
            List<Subject> subjectList = subjectService.getObjectsByIds(subjectIdsR);

            Map<Long, String> periodId_alias = MyListUtil.convert2Map(Period.class.getDeclaredField("id"), Period.class.getDeclaredField("periodName"), periodList);
            Map<Long, String> lessonId_alias = MyListUtil.convert2Map(Lesson.class.getDeclaredField("id"), Lesson.class.getDeclaredField("lessonName"), lessonList);
            Map<Long, String> subjectId_alias = MyListUtil.convert2Map(Subject.class.getDeclaredField("id"), Subject.class.getDeclaredField("subjectName"), subjectList);

            model.addAttribute("taskList", taskList);
            model.addAttribute("periodId_alias", periodId_alias);
            model.addAttribute("lessonId_alias", lessonId_alias);
            model.addAttribute("subjectId_alias", subjectId_alias);
            log.info("collection taskIds: " + taskIds);

            Map<String, Object> relationCountParams = DynamicUtil.getUserFavoriteRelationList(UserFavoriteRelation.TARGET_TYPE_TASK, UserFavoriteRelation.TYPE_VIEW_RECORD, true);
            List<Long> relationTotalList = userFavoriteRelationService.getIdsByDynamicCondition(UserFavoriteRelation.class, relationCountParams, 0, Integer.MAX_VALUE);

            Integer total = 0;
            if (DataUtils.isNotNullOrEmpty(relationTotalList)) {
                total = relationTotalList.get(0).intValue();
            }

            log.info(" total = " + total);
            Integer totalPage = (((total - 1)) / size) + 1;
            log.info("   totalPage = " + totalPage);


            if (totalPage > page) {
                next = true;
            }

            model.addAttribute("code", 0);
            model.addAttribute("next", next);
            model.addAttribute("page", page);
            model.addAttribute("total", total);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("taskList", taskList);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get collection task error ");
            model.addAttribute("code", -1);
        }

        return "/academy-course-service/lesson/json/userFavoriteLesson";

    }

    // 用户专题购买记录
    @RequestMapping(value = "/a/u/lesson/list/bought", method = RequestMethod.GET)
    public String getUserCourseRelationListJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page, Integer size, Long userId) {


        if (null == page) {
            page = 1;
        }
        if (null == size) {
            size = 10;
        }

        int start = (page - 1) * size;
        Boolean next = false;

        try {

            if (DataUtils.isNullOrEmpty(userId)) {

                model.addAttribute("code", -2000);
                return "/common/success";
            }

            List<Long> relationIds = userCourseRelationService.getUesrCourseRelationIdsByUidOrderByCreateAt(userId, start, size);
            List<Long> relationTotalIds = userCourseRelationService.getUesrCourseRelationIdsByUidOrderByCreateAt(userId, 0, Integer.MAX_VALUE);

            List<UesrCourseRelation> userCourseRelations = userCourseRelationService.getObjectsByIds(relationIds);

            List<Long> lessonIds = MyListUtil.getList(UesrCourseRelation.class.getDeclaredField("targetId"), userCourseRelations);
            List<Lesson> lessonList = lessonService.getObjectsByIds(lessonIds);

            List<Long> subjectIds = MyListUtil.getList(Lesson.class.getDeclaredField("subjectId"), lessonList);
            List<Subject> subjectList = subjectService.getObjectsByIds(subjectIds);

            Map<Long, String> subjectId_alias = MyListUtil.convert2Map(Subject.class.getDeclaredField("id"), Subject.class.getDeclaredField("subjectName"), subjectList);
            Map<Long, Integer> subjectStatusMap = MyListUtil.convert2Map(Subject.class.getDeclaredField("id"), Subject.class.getDeclaredField("status"), subjectList);

            Map<Long, Integer> lessonStatusMap = new HashMap<>();

            for (Lesson lesson : lessonList) {

                // 判断该专题父科目的状态 和 本身的状态
                Integer fatherSubjectStatus = subjectStatusMap.get(lesson.getId());
                if (Subject.status_normal.equals(fatherSubjectStatus) || !Lesson.status_normal.equals(lesson.getStatus())) {
                    lessonStatusMap.put(lesson.getId(), Lesson.status_freeze);
                } else {
                    lessonStatusMap.put(lesson.getId(), Lesson.status_normal);
                }
            }

            Integer total = 0;
            if (DataUtils.isNotNullOrEmpty(lessonList)) {
                total = relationTotalIds.size();
            }

            log.info(" total = " + total);
            Integer totalPage = (((total - 1)) / size) + 1;
            log.info("   totalPage = " + totalPage);


            if (totalPage > page) {
                next = true;
            }

            // 专题名  科目名  年级部名  状态
            model.addAttribute("code", 0);
            model.addAttribute("size", size);
            model.addAttribute("next", next);
            model.addAttribute("page", page);
            model.addAttribute("total", total);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("subjectId_alias", subjectId_alias);
            model.addAttribute("lessonStatusMap", lessonStatusMap);
            model.addAttribute("lessonList", lessonList);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get collection task error ");
            model.addAttribute("code", -1);
        }


        return "/academy-course-relation-service/course/json/lessonUserBuy";
    }

    /**
     * @param userId 用户id
     * @Description 推广详情
     * @Author: tzr
     * @Time 2017/2/10 12:24
     */
    @RequestMapping(value = "/a/u/recommend/detail/{userId}", method = RequestMethod.GET)
    public String recommendDetail(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long userId)
            throws Exception {

        log.info("get recommend detail : id = " + userId);

        Manager manager = (Manager) request.getAttribute("manager");
        Long managerId = manager.getId();
        UserRecommend userRecommend = null;

        try {
            //确认用户是否存在
            User user = userService.getObjectById(userId);
            if (null == user) {
                model.addAttribute("code", -2000);
                log.info("user not exist");
                return "/common/success";
            }
            log.info("user exist : " + user.getId());

            //确定用户是否是推广人
            if (DataUtils.isNullOrEmpty(user.getRecommendFlag()) || User.IS_NOT_MEMBER == user.getRecommendFlag()) {
                //用户不是推广人且无userRecommend数据（错误）
                model.addAttribute("code", -10000);
                log.info("user not recommend");
                return "/common/success";
            }

            Long userRecommendId = userRecommendService.getUserRecommendByUserId(userId);
            if (DataUtils.isNotNullOrEmpty(userRecommendId)) {
                userRecommend = userRecommendService.getObjectById(userRecommendId);
            }
            if (null == userRecommend) {
                //用户是推广人有邀请码但是无userRecommend数据（可能是老版本数据，补充userRecommend数据）
                UserRecommend newUserRecommend = new UserRecommend();
                newUserRecommend.setUserId(userId);
                log.info("insert newUserRecommend : " + newUserRecommend);
                Long insert = userRecommendService.insert(newUserRecommend);
                userRecommend = userRecommendService.getObjectById(userId);
                log.info("user recommend info not exist , create and insert data : " + insert);
            } else {
                log.info("user recommend id is : " + userRecommend.getId());
            }

            log.info("get user " + userId + " recommend info success");

            model.addAttribute("code", 0);
            model.addAttribute("user", user);
            model.addAttribute("userRecommend", userRecommend);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("change recommend status error,id is  " + userId);
            model.addAttribute("code", -1);

        }

        return "/academy-user-service/user/json/recommendDetail";
    }

    /**
     * @param userId 用户id
     * @Description 启用/禁用推广人
     * @Author: tzr
     * @Time 2018/4/4 11:39
     */
    @RequestMapping(value = "/a/u/user/promoter/{userId}/status/{status}", method = RequestMethod.PUT)
    public String changeRecommendStatus(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long userId, @PathVariable Integer status)
            throws Exception {

        log.info("change recommend status : userId = " + userId + ", status is " + status);

        try {
            //确认用户是否存在
            User user = userService.getObjectById(userId);
            if (null == user) {
                model.addAttribute("code", -2000);
                log.info("user not exist");
                return "/common/success";
            }
            log.info("user exist and UserId is: " + user.getId());


            if (UserRecommend.Recommend_forbidden != status && UserRecommend.Recommend_normal != status) {
                model.addAttribute("code", -1002);
                log.info("user not recommend");
                return "/common/success";
            }

            Long usRcmdId = userRecommendService.getUserRecommendByUserId(userId);
            UserRecommend usRcmd = userRecommendService.getObjectById(usRcmdId);
            if (null == usRcmd) {
                //用户是推广人有邀请码但是无userRecommend数据（可能是老版本数据，补充userRecommend数据）
                UserRecommend newUserRecommend = new UserRecommend();
                newUserRecommend.setUserId(userId);
                newUserRecommend.setRecommendStatus(status);
                userRecommendService.insert(newUserRecommend);
            } else {
                usRcmd.setRecommendStatus(status);
                boolean update = userRecommendService.update(usRcmd);
                log.info("update user recommend status result is : " + update);
            }
            user.setRecommendFlag(status);
            boolean update = userService.update(user);

            log.info("update user rcmFlag " + update);
            log.info("user " + userId + " change recommend status success");
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("change recommend status error,userId is  " + userId);
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }


    //启用、禁用邀请码
    @RequestMapping(value = "/a/u/user/invitationCode/{userId}/status/{status}", method = RequestMethod.PUT)
    public String changeInvcodeRecommendStatus(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long userId, @PathVariable Integer status)
            throws Exception {

        log.info("change invCode status : userId = " + userId + ", status is " + status);

        try {
            //确认用户是否存在
            User user = userService.getObjectById(userId);
            if (null == user) {
                model.addAttribute("code", -2000);
                log.info("user not exist");
                return "/common/success";
            }
            log.info("user exist and UserId is: " + user.getId());

            if (UserRecommend.Recommend_forbidden != status && UserRecommend.Recommend_normal != status) {
                model.addAttribute("code", -1002);
                log.info("user not recommend");
                return "/common/success";
            }

            user.setInvitationCodeStatus(status);
            boolean update = userService.update(user);

            log.info("update user rcmFlag " + update);
            log.info("user " + userId + " change recommend status success");
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("change recommend status error, userId is  " + userId);
            model.addAttribute("code", -1);

        }

        return "/common/success";

    }


    /**
     * @param userId 用户id
     * @Description 推广名单
     * @Author: tzr
     * @Time 2018/4/4 17:44
     */
    @RequestMapping(value = "/a/recommend/list/{userId}", method = RequestMethod.GET)
    public String getRecommendList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                   @PathVariable Long userId, Integer page, Integer size) throws Exception {

        log.info("get user : " + userId + " recommend list ");

        Boolean next = false;

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        try {
            //确认用户是否存在
            User user = userService.getObjectById(userId);
            if (null == user) {
                model.addAttribute("code", -2000);
                log.info("user not exist");
                return "/common/success";
            }
            log.info("user exist :  userId is " + user.getId());


            //确定用户是否是推广人
            if (DataUtils.isNullOrEmpty(user.getRecommendFlag()) || User.IS_NOT_MEMBER == user.getRecommendFlag()) {
                //用户不是推广人且无userRecommend数据（错误）
                model.addAttribute("code", -10000);
                log.info("user not recommend");
                return "/common/success";
            }

            List<Long> uids = userService.getUserIdsByRecommendId(userId, start, size);
            List<User> users = userService.getObjectsByIds(uids);
            log.info("get  user data is " + users.size());

            for (User u : users) {
                List<Long> userMemberRelationIds = userMemberRelationService.getUserMemberRelationIdsByUidAndStatus(u.getId(), User.IS_MEMBER, 0, 1);
                if (CollectionUtils.isEmpty(userMemberRelationIds)) {
                    log.info(" user " + u.getId() + " is not a member ");
                    u.setIsMember(User.IS_NOT_MEMBER);

                } else {
                    log.info(" user " + u.getId() + "  member record id = " + userMemberRelationIds.get(0));
                    UserMemberRelation userMemberRelation = userMemberRelationService.getObjectById(userMemberRelationIds.get(0));
                    Long now = System.currentTimeMillis();
                    log.info(" user member endAt is " + getDate(userMemberRelation.getEndAt()) + " now is " + getDate(now));
                    if (now.longValue() >= userMemberRelation.getEndAt().longValue()) {
                        log.info(" user member is out of date ");
                        userMemberRelation.setStatus(User.IS_NOT_MEMBER);
                        userMemberRelationService.update(userMemberRelation);
                        u.setIsMember(User.IS_NOT_MEMBER);

                    } else {
                        log.info(" user is member ");
                        u.setIsMember(User.IS_MEMBER);
                    }
                }
            }

            log.info(" total = " + uids.size());
            model.addAttribute("userCount", uids.size());

            Integer totalPage = (((uids.size() - 1)) / size) + 1;
            log.info("   totalPage = " + totalPage);

            if (uids != null && uids.size() > 0) {
                if (size.equals(uids.size())) {
                    next = true;
                    uids = uids.subList(0, size);
                }
            }
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("userList", users);
            model.addAttribute("code", 0);
            model.addAttribute("next", next);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update recommend discount error,id is  " + userId);
            model.addAttribute("code", -1);

        }

        return "/academy-user-service/user/json/recommendList";
    }

}

