package com.ptteng.academy.admin.controller;

import com.ptteng.academy.user.model.Sign;
import com.ptteng.academy.user.service.SignService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Sign  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class SignController {
	private static final Log log = LogFactory.getLog(SignController.class);

	@Autowired
	private SignService signService;






    /**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/c/sign", method = RequestMethod.GET)
	public String getsignList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model) throws Exception {

		
		
		log.info("/sign  to /sign/view/signList");

		return "/academy-user-service/sign/view/signList";
	}
    
    

    		
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 
	
		 @RequestMapping(value = "/c/sign1 ", method = RequestMethod.GET)
	public String getSignIdsByUidOrderByCreateAtList1(HttpServletRequest request,
													  HttpServletResponse response, ModelMap model, Long uid) throws Exception {

		log.info("/sign  to /sign/view/signList");

		return "/academy-user-service/sign/view/signList";
	}

	
	
	
	
	
	
	@RequestMapping(value = "/c/sign/{id}", method = RequestMethod.GET)
	public String getSign(HttpServletRequest request,
						  HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("/sign/" + id + "  to /sign/view/signDeail");
		if(null != id){
			model.addAttribute("id", id);
		}else{
			model.addAttribute("id", 0);
		}

		return "/academy-user-service/sign/view/signDetail";
	}
	
	
	
	    		
			
    /**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	
		@RequestMapping(value = "/a/sign1 ", method = RequestMethod.GET)
	public String getSignIdsByUidOrderByCreateAtJsonList(HttpServletRequest request,
														 HttpServletResponse response, ModelMap model, Integer page,
														 Integer size, Long uid) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids= signService.getSignIdsByUidOrderByCreateAt(uid,start,size);
		log.info("get countSignIdsByUidOrderByCreateAt size is " + ids.size());

			List<Sign> signList = signService.getObjectsByIds(ids);
			log.info("get sign data is " + signList.size());

			Integer total = signService. countSignIdsByUidOrderByCreateAt(uid);
			log.info("get sign count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			
			model.addAttribute("total", total);

			model.addAttribute("signList", signList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get sign list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/academy-user-service/sign/json/signListJson";
	}

	
	
		
	
	

	@RequestMapping(value = "/a/sign/{id}", method = RequestMethod.GET)
	public String getSignJson(HttpServletRequest request,
							  HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			Sign sign = signService.getObjectById(id);
			log.info("get sign data is " + sign);

			model.addAttribute("code", 0);

			model.addAttribute("sign", sign);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get sign error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/academy-user-service/sign/json/signDetailJson";
	}

	@RequestMapping(value = "/a/sign/{id}", method = RequestMethod.PUT)
	public String updateSignJson(HttpServletRequest request,
								 HttpServletResponse response, ModelMap model, Sign sign) throws Exception {
		
		log.info("update sign : sign= " + sign);
		
		try {
			
			signService.update(sign);

			model.addAttribute("code", 0);

			model.addAttribute("sign", sign);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update sign error,id is  " + sign.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/sign", method = RequestMethod.POST)
	public String addSignJson(HttpServletRequest request,
							  HttpServletResponse response, ModelMap model, Sign sign) throws Exception {
		
		log.info("update sign : sign= " + sign);
		
		try { 
			sign.setId(null);

			signService.insert(sign);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add sign error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/sign/{id}", method = RequestMethod.DELETE)
	public String deleteSignJson(HttpServletRequest request,
								 HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete sign : id= " + id);
		try {
			signService.delete(id);

			log.info("add sign success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete sign error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/a/multi/sign", method = RequestMethod.GET)
	public String getMultiSignJson(HttpServletRequest request,
								   HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<Sign> signList = signService.getObjectsByIds(idList);
			log.info("get  sign data is " + signList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",signList.size());

			model.addAttribute("signList", signList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get sign error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/academy-user-service/sign/json/signListJson";
	}

	
	
	
	
}

