package com.ptteng.academy.admin.controller;

import com.gemantic.common.util.MyListUtil;
import com.gemantic.common.util.StringUtil;
import com.ptteng.academy.admin.util.DynamicUtil;
import com.ptteng.academy.admin.util.StatisticsUtil;
import com.ptteng.academy.user.model.RecommendStatistics;
import com.ptteng.academy.user.model.User;
import com.ptteng.academy.user.model.UserRecommend;
import com.ptteng.academy.user.service.RecommendStatisticsService;
import com.ptteng.academy.user.service.UserRecommendService;
import com.ptteng.academy.user.service.UserService;
import com.qding.common.util.DataUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * RecommendStatistics  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class RecommendStatisticsController {
    private static final Log log = LogFactory.getLog(RecommendStatisticsController.class);

    @Autowired
    private RecommendStatisticsService recommendStatisticsService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserRecommendService userRecommendService;


    /**
     * 推广统计
     *
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @param invitationCode         邀请码
     * @param alias                  推广人名称
     * @param pendingSettlementStart 注册量起始
     * @param pendingSettlementEnd   注册量终止
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/recommend/search", method = RequestMethod.GET)
    public String getRecommendList(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page,
                                   Integer size, String invitationCode, String alias, String registersStart,
                                   String registersEnd, String minDiscount, String maxDiscount, String pendingSettlementStart,
                                   String pendingSettlementEnd, Integer recommendStatus, String mobile, String mail) throws Exception {

        log.info("page===" + page + "size====" + size + " alias = " + alias + " invitationCode = " + invitationCode + "" + " registerNumStart = "
                + registersStart + " registerNumEnd = " + registersEnd + " minDiscount = " + minDiscount + "" + " maxDiscount = " + maxDiscount +
                " minSettlement = " + pendingSettlementStart + " maxSettlement = " + pendingSettlementEnd + " recommendStatus = " + recommendStatus + "" +
                " mobile = " + mobile + " mail = " + mail);
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        try {
            Map<String, Object> userParam = StatisticsUtil.getRecommendList(invitationCode, alias, registersStart, registersEnd, minDiscount, maxDiscount,
                    pendingSettlementStart, pendingSettlementEnd, recommendStatus, mobile, mail, false);
            List<Long> uids = userService.getIdsByDynamicCondition(User.class, userParam, start, size);
            List<Long> totalIds = userService.getIdsByDynamicCondition(User.class, userParam, 0, Integer.MAX_VALUE);

            log.info(" get uid users size  = " + uids.size());


            Map<String, Object> userRecmParam = DynamicUtil.getUserRecommendList(uids);
            List<Long> userRmdIds = userRecommendService.getIdsByDynamicCondition(UserRecommend.class, userRecmParam, 0, Integer.MAX_VALUE);
            List<UserRecommend> userRecommends = userRecommendService.getObjectsByIds(userRmdIds);
            List<User> usersCurrentPage = userService.getObjectsByIds(uids);
            model.addAttribute("users", usersCurrentPage);

            Map<Long, UserRecommend> id_userRecommend = MyListUtil.convert2Map(UserRecommend.class.getDeclaredField("userId"), userRecommends);
            model.addAttribute("id_userRecommend", id_userRecommend);

            log.info(" get total size = " + userRecommends.size());
            int total = totalIds.size();
            int totalPage = 1;
            if (total > 0) {
                totalPage = (total - 1) / size + 1;
            }

            Map<Long, Integer> userId_reigs_map = new HashMap<>();
            for (Long uid : uids) {
                UserRecommend regis = id_userRecommend.get(uid);
                if (DataUtils.isNotNullOrEmpty(regis)) {
                    if (DataUtils.isNotNullOrEmpty(regis.getRecommendNum())) {
                        userId_reigs_map.put(uid, regis.getRecommendNum());
                    }
                } else {
                    userId_reigs_map.put(uid, 0);
                }
            }
            model.addAttribute("userId_reigs_map", userId_reigs_map).addAttribute("code", 0).addAttribute("total", total).addAttribute("totalPage", totalPage);
            model.addAttribute("size", size).addAttribute("page", page);

            return "/academy-user-service/recommendStatistics/json/getRecommendListJson";

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get lotteryList  error,page is  " + start + " , size "
                    + size);
            model.addAttribute("code", -1);
        }

        log.info("/web/product  to /product/json/productList");

        return "/common/success";
    }

    // 日月统计
    @RequestMapping(value = "/a/recommend/day/search/{userId}", method = RequestMethod.GET)
    public String getproductList(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, Integer page, Integer size,
                                 Long startAt, Long endAt, @PathVariable Long userId,
                                 String period) throws Exception {

        log.info("page===" + page + "size====" + size + " userId = " + userId + " period = " + period + " startAt = " + startAt + " endAt = " + endAt);
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        try {

            if (null == userId) {
                model.addAttribute("code", -1000);
                return "/common/success";
            }

            User user = userService.getObjectById(userId);
            model.addAttribute("name", user.getAlias());
            if (StringUtils.isBlank(period)) {
                period = StatisticsUtil.Period_Day;
            }
            // 日统计
            if (StatisticsUtil.Period_Day.equals(period)) {

                Map<String, Object> rcmdStatParam = StatisticsUtil.getDailyStatistcsList(startAt, endAt, userId, false);
                List<Long> rcmdStatIds = recommendStatisticsService.getIdsByDynamicCondition(RecommendStatistics.class, rcmdStatParam, start, size);
                log.info(" get Daily list ids size = " + rcmdStatIds.size());

                List<RecommendStatistics> recommendStatisticsList = recommendStatisticsService.getObjectsByIds(rcmdStatIds);
                log.info(" DailyList size = " + recommendStatisticsList.size());
                for (RecommendStatistics recommendStatistics : recommendStatisticsList) {
                    recommendStatistics.setDate(getDate(recommendStatistics.getStaticAt()));
                }

                model.addAttribute("recommendStatisticsList", recommendStatisticsList);

                BigInteger total = new BigInteger("0");
                BigInteger totalPage = new BigInteger("0");

                Map<String, Object> mapTotal = StatisticsUtil.getDailyStatistcsList(startAt, endAt, userId, true);
                log.info(" get recommend total size param = " + mapTotal);
                total = (BigInteger) recommendStatisticsService.getObjectByDynamicCondition(RecommendStatistics.class, mapTotal, 0, Integer.MAX_VALUE);
                log.info(" get recommend total size = " + total);

                totalPage = new BigInteger("1");
                if (total.compareTo(new BigInteger("0")) == 1) {
                    totalPage = ((total.subtract(new BigInteger("1"))).divide(new BigInteger("" + size))).add(new BigInteger("1"));
                }
                model.addAttribute("total", total);
                model.addAttribute("totalPage", totalPage);
            } else {
                //周统计和月统计
                Map<String, Object> map = StatisticsUtil.getStatisticsGroupParam(period, userId, startAt, endAt);
                log.info(" get Daily list param = " + map);

                Object queryResults = recommendStatisticsService.getObjectByDynamicCondition(RecommendStatistics.class, map, start, size);
                List<RecommendStatistics> recommendStatisticsList = new ArrayList<>();

                int i = 0;
                RecommendStatistics rcmdStat = new RecommendStatistics();
                if (queryResults instanceof ArrayList) {
                    ArrayList resultArrays = (ArrayList) queryResults;
                    int statisticsSize = resultArrays.size();
                    for (Object result : resultArrays) {
                        Object[] rs = (Object[]) result;

                        log.info(" 0 " + rs[0] + " 1=" + rs[1] + " 2=" + rs[2] + " week = " + rs[2]);
                        rcmdStat.setRegisters(new BigDecimal(rs[0] + ""));
                        rcmdStat.setAmount(new BigDecimal(rs[1] + ""));
                        String week = rs[2] + "";
                        rcmdStat.setDate(StatisticsUtil.getStatisticsDate(period, week, i, startAt, endAt, statisticsSize));
                        recommendStatisticsList.add(rcmdStat);
                        i++;
                        log.info("week date is  " + rcmdStat.getDate());
                    }

                } else {
                    Object[] rs = (Object[]) queryResults;
                    log.info(" 0 " + rs[0] + " 1=" + rs[1] + " 2=" + rs[2] + " week = " + rs[2]);
                    rcmdStat.setRegisters(new BigDecimal(rs[0] + ""));
                    rcmdStat.setAmount(new BigDecimal(rs[1] + ""));

                    String week = rs[2] + "";
                    rcmdStat.setDate(StatisticsUtil.getStatisticsDate(period, week, i, startAt, endAt, 1));
                    recommendStatisticsList.add(rcmdStat);
                    i++;
                    log.info("week date is  " + rcmdStat.getDate());

                }
                model.addAttribute("recommendStatisticsList", recommendStatisticsList);
                Object totalResults = recommendStatisticsService.getObjectByDynamicCondition(RecommendStatistics.class, map, 0, Integer.MAX_VALUE);
                if (totalResults instanceof ArrayList) {
                    ArrayList resultArrays = (ArrayList) totalResults;
                    int total = ((ArrayList) totalResults).size();
                    int totalPage = 1;
                    if (total > 0) {
                        totalPage = (total - 1) / size + 1;
                    }
                    model.addAttribute("total", total);
                    model.addAttribute("totalPage", totalPage);
                } else {
                    Object[] rs = (Object[]) totalResults;
                    log.info("  rs length = " + rs.length);
                    int total = 0;
                    if (rs.length == 10) {
                        total = 1;
                    }
                    int totalPage = 1;
                    model.addAttribute("total", total);
                    model.addAttribute("totalPage", totalPage);
                }
            }
            model.addAttribute("code", 0);
            model.addAttribute("size", size);
            model.addAttribute("page", page);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get lotteryList  error,page is  " + start + " , size "
                    + size);
            model.addAttribute("code", -1);
        }

        log.info("/web/recommend  to /recommend/json/recommendList");
        return "/academy-user-service/recommendStatistics/json/recommendStatisticsListJson";
    }

    public static String getDate(Long time) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String date = "";
        if (null != time) {
            date = dateFormat.format(new Date(time));
        }
        return date;
    }


    /**
     * @param userId 用户id
     * @param type   结算类型
     * @param amount 结算金额
     * @Description 结算
     * @Author: tongzhirong
     * @Time 2018/4/2 16:33
     */
    @RequestMapping(value = "/a/u/user/settlement/{userId}", method = RequestMethod.PUT)
    public String settlement(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long userId, Integer type, String amount) throws Exception {

        log.info("set recommend discount : id = " + userId + " type = " + type + " amount = " + amount);
        UserRecommend userRecommend = null;
        BigDecimal amountNum = BigDecimal.ZERO;
        if (StringUtil.isEmpty(amount) || type == null) {
            model.addAttribute("code", -1000);
            log.info("discount null");
            return "/common/success";
        }
        //校验折扣参数是否合法
        try {
            amountNum = new BigDecimal(amount);
        } catch (NumberFormatException e) {
            model.addAttribute("code", -10002);
            log.info("amount illegal");
            return "/common/success";
        }
        log.info("params OK");

        //确认用户是否存在
        User user = userService.getObjectById(userId);
        if (null == user) {
            model.addAttribute("code", -2000);
            log.info("user not exist");
            return "/common/success";
        }
        log.info("user exist and userId is: " + user.getId());


        //确定用户是否是推广人
        if (User.IS_NOT_MEMBER == user.getRecommendFlag()) {
            //用户不是推广人且无userRecommend数据（错误）
            model.addAttribute("code", -10000);
            log.info("user not recommend");
            return "/common/success";
        }

        try {
            Long userRecommendId = userRecommendService.getUserRecommendByUserId(userId);
            if (DataUtils.isNotNullOrEmpty(userRecommendId)) {
                userRecommend = userRecommendService.getObjectById(userRecommendId);
            }

            if (DataUtils.isNullOrEmpty(userRecommend)) {
                //用户是推广人有邀请码但是无userRecommend数据（可能是老版本数据，补充userRecommend数据）
                UserRecommend newUserRecommend = new UserRecommend();
                newUserRecommend.setId(userId);
                userRecommendService.insert(newUserRecommend);

                //用户无userRecommend数据,无法结算（错误）
                model.addAttribute("code", -10003);
                log.info("user not recommend");
                return "/common/success";
            }

            // 将结算金额加上原结算金额，判断是否超过推广销售额
            BigDecimal settlementBefore = BigDecimal.ZERO;
            BigDecimal amountTotal = BigDecimal.ZERO;
            String balanceType = "";
            if (UserRecommend.android.equals(type)) {
                settlementBefore = userRecommend.getAndroidSettlement();
                amountTotal = userRecommend.getAndroidAmount();
                balanceType = "android";
            } else {
                settlementBefore = userRecommend.getIosSettlement();
                amountTotal = userRecommend.getIosAmount();
                balanceType = "ios";
            }
            log.info(balanceType + " settlementBefore : " + settlementBefore + " amountTotal : " + amountTotal);
            BigDecimal settlementTotal = amountNum.add(settlementBefore);

            //结算总金额小于推广销售总金额，且结算金额大于0
            if ((amountTotal.compareTo(settlementTotal) == -1) || (amountNum.compareTo(BigDecimal.ZERO) == -1)) {
                model.addAttribute("code", -10004);
                log.info("settlement amount illegal");
                return "/common/success";
            }

            log.info("amountNum " + amountNum + " legal");
            //加上结算金额记录
            if (UserRecommend.android.equals(type)) {
                userRecommend.setAndroidSettlement(settlementTotal);
                log.info("user : " + userId + " Android settlement amount : " + settlementBefore + " >>>>>>>>>> " + settlementTotal);
            } else {
                userRecommend.setIosSettlement(settlementTotal);
                log.info("user : " + userId + " iOS settlement amount : " + settlementBefore + " >>>>>>>>>> " + settlementTotal);
            }

            log.info("update user recommend : " + userRecommend);
            userRecommendService.update(userRecommend);
            log.info("user " + userId + " update recommend settlement success");

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update recommend settlement error,userId is  " + userId);
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }
}

