package com.ptteng.academy.admin.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.MyListUtil;
import com.gemantic.common.util.MyMapUtil;
import com.ptteng.academy.admin.exception.MyException;
import com.ptteng.academy.admin.util.AcademyCourseLessonUtil;
import com.ptteng.academy.admin.util.AcademyCourseTaskUtil;
import com.ptteng.academy.admin.util.DynamicUtil;
import com.ptteng.academy.course.model.*;
import com.ptteng.academy.course.service.*;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * PageStatistic  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class PageStatisticController {
    private static final Log log = LogFactory.getLog(PageStatisticController.class);

    @Autowired
    private PageStatisticService pageStatisticService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private UnitService unitService;
    @Autowired
    private LessonService lessonService;
    @Autowired
    private SubjectService subjectService;
    @Autowired
    private PeriodService periodService;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @RequestMapping(value = "/a/u/lesson/stat/list", method = RequestMethod.GET)
    public String getLessonsOrderBySortJsonList(HttpServletRequest request,
                                                HttpServletResponse response, ModelMap model,
                                                Integer page,
                                                Integer size, String subjectName, Long lessonId,
                                                Integer isMember, Integer os, Integer gradeDept, Long startAt, Long endAt) throws ServiceException, ServiceDaoException {

        log.info("get lesson subject is " + subjectName + " lessonId is " + lessonId);
        if (page == null) {
            page = 1;
        }
        if (size == null) {

            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        try {
            if (DataUtils.isNotNullOrEmpty(lessonId)) {
                List lessonList = new ArrayList();
                Lesson lesson = lessonService.getObjectById(lessonId);

                Long subjectId = lesson.getSubjectId();
                Subject subject = subjectService.getObjectById(subjectId);
                if (!Subject.status_normal.equals(subject.getStatus()) || !Lesson.status_normal.equals(lesson.getStatus())) {
                    model.addAttribute("lessonList", lessonList);
                    return "/academy-course-service/lesson/json/lessonListJson";
                }
                lessonList.add(lesson);
                lesson.setSubjectName(subject.getSubjectName());
                Map<Long, String> subjectId_alias = new HashMap<>();
                subjectId_alias.put(subject.getId(), subject.getSubjectName());

                model.addAttribute("code", 0);
                model.addAttribute("next", false);
                model.addAttribute("totalPage", 1);
                model.addAttribute("page", page);
                model.addAttribute("size", size);
                model.addAttribute("total", 1);
                model.addAttribute("subjectId_alias", subjectId_alias);

                //   要是hhhhhh   bnnmm,....fjhkk;l;l'';/kuyyyytt`r`1r1r擦 统计数据
                List lessonIds = new ArrayList();
                lessonIds.add(lessonId);
                Map<String, Object> statParam = DynamicUtil.getPageStatisticsList(lessonIds, PageStatistic.LESSON, os, isMember, startAt, endAt);
                List<Long> statIdList = pageStatisticService.getIdsByDynamicCondition(PageStatistic.class, statParam, 0, Integer.MAX_VALUE);
                List<PageStatistic> statList = pageStatisticService.getObjectsByIds(statIdList);

                Map<Long, List<PageStatistic>> targetId_stat_Map = MyListUtil.convert2ListMap(PageStatistic.class.getDeclaredField("targetId"), statList);
                List<Map.Entry<Long, List<PageStatistic>>> entries = MyMapUtil.converMapToEntryList(targetId_stat_Map);

                Map<Long, Integer> id_viewStat_map = new HashMap<>();
                Map<Long, Integer> id_collectStat_map = new HashMap<>();
                Map<Long, Integer> id_cacheStat_map = new HashMap<>();
                countViewStat(id_viewStat_map, id_collectStat_map, id_cacheStat_map, entries);

                model.addAttribute("lessonList", lessonList);
                model.addAttribute("id_viewStat_map", id_viewStat_map);
                return "/academy-course-service/lesson/json/lessonListJson";
            }


            // 根据subjectName 来找到对应的subjectId
            Map<String, Object> subjectParam = DynamicUtil.getSubjectList(subjectName, null, null);
            List<Long> subjectIds = subjectService.getIdsByDynamicCondition(Subject.class, subjectParam, 0, Integer.MAX_VALUE);
            Map<String, Object> lessonParam = DynamicUtil.getLessonList(null, subjectIds, null, gradeDept);
            List<Long> lessonIds = lessonService.getIdsByDynamicCondition(Lesson.class, lessonParam, 0, Integer.MAX_VALUE);

            // 取得上架专题，获取lessonId，取得每页条数
            List<Lesson> lessonList = AcademyCourseLessonUtil.getNormalLessonList(lessonIds);
            List<Long> normalLessonIds = MyListUtil.getList(Lesson.class.getDeclaredField("id"), lessonList);
            log.info("=============== get normalLessonIds size is " + normalLessonIds.size());

            List<Long> normalLessonIdsByRange = MyListUtil.getPageList(normalLessonIds, page, size);
            List<Lesson> normalLessonList = lessonService.getObjectsByIds(normalLessonIdsByRange);
            log.info("=============== get normalLessonIdList size is " + normalLessonList.size());

            List<Long> subjectIdsOfLesson = MyListUtil.getFieldValueListFromModelList(normalLessonList, false, Lesson.class.getDeclaredField("subjectId"));
            List<Subject> subjectList = subjectService.getObjectsByIds(subjectIdsOfLesson);
            Map<Long, String> subjectId_alias = MyListUtil.convert2Map(Subject.class.getDeclaredField("id"), Subject.class.getDeclaredField("subjectName"), subjectList);

            //统计数据
            Map<String, Object> statParam = DynamicUtil.getPageStatisticsList(null, PageStatistic.LESSON, os, isMember, startAt, endAt);
            List<Long> statIdList = pageStatisticService.getIdsByDynamicCondition(PageStatistic.class, statParam, 0, Integer.MAX_VALUE);
            List<PageStatistic> statList = pageStatisticService.getObjectsByIds(statIdList);
            Map targetId_stat_Map = MyListUtil.convert2ListMap(PageStatistic.class.getDeclaredField("targetId"), statList);

            List<Map.Entry<Long, List<PageStatistic>>> lessonId_Stat_Entry = MyMapUtil.converMapToEntryList(targetId_stat_Map);
            Map<Long, Integer> id_viewStat_map = new HashMap<>();
            for (Map.Entry<Long, List<PageStatistic>> entry : lessonId_Stat_Entry) {
                Long psId = entry.getKey();
                Integer viewStatCount = 0;

                List<PageStatistic> statisticList = entry.getValue();
                for (PageStatistic ps : statisticList) {
                    viewStatCount += ps.getViewsStat();
                    id_viewStat_map.put(psId, viewStatCount);

                }
            }

            for (Long lssnId : normalLessonIds) {
                if (!id_viewStat_map.containsKey(lssnId)) {
                    id_viewStat_map.put(lssnId, 0);
                }
            }


            Integer total = normalLessonIds.size();
            log.info("get normalLessonIds count is " + total);
            boolean next = false;
            if (normalLessonIdsByRange.size() + start + 1 <= total) {
                next = true;
            }


            model.addAttribute("code", 0);
            model.addAttribute("next", next);
            model.addAttribute("totalPage", (total - 1) / size + 1);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("subjectId_alias", subjectId_alias);
            model.addAttribute("id_viewStat_map", id_viewStat_map);
            model.addAttribute("lessonList", normalLessonList);


        } catch (Throwable t) {
            if (t instanceof MyException) {

                MyException me = (MyException) t;
                log.info(me.getMessage());
                model.addAttribute("code", me.getErrorCode());
                return "/common/success";
            }

            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get lesson list error,page is  " + start + " , size " + size);
            model.addAttribute("code", -100000);
        }

        return "/academy-course-service/pageStatistic/json/lessonListJson";
    }

    private static void countViewStat(Map<Long, Integer> id_viewStat_map, Map<Long, Integer> id_collectStat_map, Map<Long, Integer> id_cacheStat_map,
                                      List<Map.Entry<Long, List<PageStatistic>>> entries) {

        for (Map.Entry<Long, List<PageStatistic>> entry : entries) {
            List<PageStatistic> statisticList = entry.getValue();
            Integer viewStatCount = 0;
            Integer collectStatCount = 0;
            Integer cacheStatCount = 0;

            Long targetId = entry.getKey();
            for (PageStatistic ps : statisticList) {
                viewStatCount += ps.getViewsStat();
                id_viewStat_map.put(targetId, viewStatCount);
                if (DataUtils.isNotNullOrEmpty(ps.getCollectsStat())) {
                    collectStatCount += ps.getCollectsStat();
                    id_collectStat_map.put(targetId, collectStatCount);

                }
                if (DataUtils.isNotNullOrEmpty(ps.getCachesStat())) {
                    cacheStatCount += ps.getCachesStat();
                    id_cacheStat_map.put(targetId, cacheStatCount);
                }

            }
        }

    }


    /*
     * @author tongzhirong
     * */
    @RequestMapping(value = "/a/u/task/stat/list", method = RequestMethod.GET)
    public String getTaskStatListJson(HttpServletRequest request, HttpServletResponse response, Integer page, Integer size, ModelMap model,
                                      String taskName, Integer gradeDept, String subjectName, String lessonName, String periodName,
                                      Integer taskType, Integer status, Integer specificType, Integer difficultyLevel, Integer isMember, Integer os, Long startAt, Long endAt) {


        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        try {

            List<Long> subjectIds = new ArrayList<>();
            List<Long> lessonIds = new ArrayList<>();
            List<Long> periodIds = new ArrayList<>();

            if (DataUtils.isNotNullOrEmpty(periodName)) {
                Map<String, Object> periodParam = DynamicUtil.getPeriodList(periodName, null, null, null, null);
                periodIds = periodService.getIdsByDynamicCondition(Period.class, periodParam, 0, Integer.MAX_VALUE);
            } else if (DataUtils.isNotNullOrEmpty(lessonName)) {
                Map<String, Object> lessonParam = DynamicUtil.getLessonList(lessonName, null, null, null);
                lessonIds = lessonService.getIdsByDynamicCondition(Lesson.class, lessonParam, 0, Integer.MAX_VALUE);
            } else if (DataUtils.isNotNullOrEmpty(subjectName)) {
                Map<String, Object> subjectParam = DynamicUtil.getSubjectList(subjectName, null, null);
                subjectIds = subjectService.getIdsByDynamicCondition(Subject.class, subjectParam, 0, Integer.MAX_VALUE);
            }

            Map<String, Object> taskParam = DynamicUtil.getTaskList(taskType, taskName, subjectIds, lessonIds, periodIds, gradeDept, status, specificType, difficultyLevel);
            List<Long> taskIds = taskService.getIdsByDynamicCondition(Task.class, taskParam, 0, Integer.MAX_VALUE);
            // 取得上架 task
            List<Long> normalTaskIdList = AcademyCourseTaskUtil.getNormalTaskIds(taskIds);
            List<Task> normalTaskPageList = taskService.getObjectsByIds(normalTaskIdList);
            normalTaskPageList = MyListUtil.getPageList(normalTaskPageList, page, size);
            List<Long> periodIdsR = MyListUtil.getList(Task.class.getDeclaredField("periodId"), normalTaskPageList);
            List<Long> lessonIdsR = MyListUtil.getList(Task.class.getDeclaredField("lessonId"), normalTaskPageList);
            List<Long> subjectIdsR = MyListUtil.getList(Task.class.getDeclaredField("subjectId"), normalTaskPageList);

            List<Period> periodList = periodService.getObjectsByIds(periodIdsR);
            List<Lesson> lessonList = lessonService.getObjectsByIds(lessonIdsR);
            List<Subject> subjectList = subjectService.getObjectsByIds(subjectIdsR);

            Map<Long, String> periodId_alias = MyListUtil.convert2Map(Period.class.getDeclaredField("id"), Period.class.getDeclaredField("periodName"), periodList);
            Map<Long, String> lessonId_alias = MyListUtil.convert2Map(Lesson.class.getDeclaredField("id"), Lesson.class.getDeclaredField("lessonName"), lessonList);
            Map<Long, String> subjectId_alias = MyListUtil.convert2Map(Subject.class.getDeclaredField("id"), Subject.class.getDeclaredField("subjectName"), subjectList);


            Map<String, Object> psParam = DynamicUtil.getPageStatisticsList(taskIds, PageStatistic.TASK, os, isMember, startAt, endAt);

            List<Long> psIds = pageStatisticService.getIdsByDynamicCondition(PageStatistic.class, psParam, 0, Integer.MAX_VALUE);
            List<PageStatistic> pgStatList = pageStatisticService.getObjectsByIds(psIds);
            Map<Long, List<PageStatistic>> targetId_stat_Map = MyListUtil.convert2ListMap(PageStatistic.class.getDeclaredField("targetId"), pgStatList);
            List<Map.Entry<Long, List<PageStatistic>>> entries = MyMapUtil.converMapToEntryList(targetId_stat_Map);


            Map<Long, Integer> id_viewStat_map = new HashMap<>();
            Map<Long, Integer> id_collectStat_map = new HashMap<>();
            Map<Long, Integer> id_cacheStat_map = new HashMap<>();
            countViewStat(id_viewStat_map, id_collectStat_map, id_cacheStat_map, entries);

            for (Long lssnId : normalTaskIdList) {
                if (!id_viewStat_map.containsKey(lssnId)) {
                    id_viewStat_map.put(lssnId, 0);
                }
                if (!id_collectStat_map.containsKey(lssnId)) {
                    id_collectStat_map.put(lssnId, 0);
                }
                if (!id_cacheStat_map.containsKey(lssnId)) {
                    id_cacheStat_map.put(lssnId, 0);
                }
            }


            Integer total = normalTaskIdList.size();
            log.info("get lesson count is " + total);

            boolean next = false;
            if (normalTaskPageList.size() + start + 1 <= total) {
                next = true;
            }
            Integer totalPage = (total - 1) / size + 1;

            model.addAttribute("code", 0);
            model.addAttribute("next", next);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("taskList", normalTaskPageList);
            model.addAttribute("periodId_alias", periodId_alias);
            model.addAttribute("lessonId_alias", lessonId_alias);
            model.addAttribute("subjectId_alias", subjectId_alias);
            model.addAttribute("id_viewStat_map", id_viewStat_map);
            model.addAttribute("id_collectStat_map", id_collectStat_map);
            model.addAttribute("id_cacheStat_map", id_cacheStat_map);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get lesson list error,page is  " + start + " , size "
                    + size);
            model.addAttribute("code", -100000);

        }

        return "/academy-course-service/pageStatistic/json/taskListJson";


    }


    @RequestMapping(value = "/a/u/common/stat/list", method = RequestMethod.GET)
    public String getUserDetailStatListJson(ModelMap model, Integer targetType, Integer os, Integer isMember, Long startAt, Long endAt) {
        try {

            Map<String, Object> psParam = DynamicUtil.getPageStatisticsList(null, targetType, os, isMember, startAt, endAt);
            List<Long> psIds = pageStatisticService.getIdsByDynamicCondition(PageStatistic.class, psParam, 0, Integer.MAX_VALUE);
            List<PageStatistic> pgStatList = pageStatisticService.getObjectsByIds(psIds);

            Integer viewStatCount = 0;
            for (PageStatistic ps : pgStatList) {
                viewStatCount += ps.getViewsStat();
            }
            model.addAttribute("code", 0);
            model.addAttribute("targetType", targetType);
            model.addAttribute("viewStatCount", viewStatCount);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get lesson list error,page is ");
            model.addAttribute("code", -100000);

        }
        return "/academy-course-service/pageStatistic/json/pageStatisticDetailJson";
    }


}

